% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rin.R
\name{rpin}
\alias{rpin}
\title{Generate a vector of random \code{pin}}
\usage{
rpin(n, start_date = "1900-01-01", end_date = Sys.Date(), p.male = 0.1,
  p.coordn = 0.1)
}
\arguments{
\item{n}{number of observations. If \code{length(n) > 1}, the length is taken to be the number required.}

\item{start_date}{Smallest possible \code{pin}. Default is 1900-01-01.}

\item{end_date}{Largest possible \code{pin}. Default is the current date.}

\item{p.male}{Proportion of males. Default is 0.5.}

\item{p.coordn}{Proportion of coordination numbers. Default is 0.1.}
}
\value{
a vector of generated \code{pin}s.
}
\description{
A function that generates random \code{pin}s (see \code{\link{as.pin}}). 
The generated \code{pin} is uniformely distributed over the time period.
}
\examples{
x <- rpin(3)
pin_ctrl(x)
pin_sex(x)
pin_age(x)

}

