% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/catSpatInterp.R
\name{catSpatInterp}
\alias{catSpatInterp}
\title{Categorical Spatial Interpolation}
\usage{
catSpatInterp(
  data,
  x.col = "x",
  y.col = "y",
  group.col = "group",
  num.grid = 100,
  knn = 10,
  hull.buffer = 0.1,
  num.cores = 1,
  num.batches = NULL
)
}
\arguments{
\item{data}{matrix or data.frame containing points and grouping designation.}

\item{x.col, y.col, group.col}{numbers or characters identifying which columns 
in \code{data} are the x and y values and grouping designation.}

\item{num.grid}{number of grid cells for k-nearest neighbor interpolation.}

\item{knn}{number of nearest neighbors to consider for interpolation.}

\item{hull.buffer}{percent increase of convex hull to use as spatial area to
interpolate over.}

\item{num.cores}{number of cores to distribute interpolations over.}

\item{num.batches}{number of batches to divide grid cell interpolations into.}
}
\value{
A list containing a raster and points of buffered convex hull.
}
\description{
Create a raster of probability of categorical values 
  interpolated across a 2-dimensional space given a set of points where 
  each is assigned to one of several classes.
}
\examples{
\dontrun{
iris.mds <- stats::cmdscale(dist(iris[, 1:4]), k = 2)
mds.df <- setNames(
  cbind(iris.mds, data.frame(iris$Species)),
  c("dim1", "dim2", "Species")
)

result <- catSpatInterp(
  mds.df, x.col = "dim1", y.col = "dim2", group.col = "Species", 
  num.grid = 300, knn = 20, hull.buffer = 0.05,
  num.cores = 5, num.batches = NULL
)

library(ggplot2)
ggplot(mapping = aes(dim1, dim2)) +
  geom_raster(
    aes(fill = Species, alpha = prob), 
    data = result$raster
  ) +
  geom_polygon(data = result$hull.poly, fill = NA, col = "black") +
  geom_hline(yintercept = 0, col = "white") +
  geom_vline(xintercept = 0, col = "white") +
  geom_point(
    aes(fill = Species), 
    data = mds.df, 
    col = "black", 
    shape = 21, 
    size = 4
  ) + 
  theme(
    axis.ticks = element_blank(),
    axis.text = element_blank(),
    axis.title = element_blank(),
    legend.position = "top",
    panel.grid = element_blank(),
    panel.background = element_blank()
  )
}

}
\references{
Adapted from code originally presented in a blog post on 
  Categorical Spatial Interpolation by Timo Grossenbacher
  \url{https://timogrossenbacher.ch/2018/03/categorical-spatial-interpolation-with-r/}
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
