% Generated by roxygen2 (4.0.1.99): do not edit by hand
\name{install_from_swirl}
\alias{install_from_swirl}
\title{Install a course from the official course repository}
\usage{
install_from_swirl(course_name, dev = FALSE)
}
\arguments{
\item{course_name}{The name of the course you wish to install.}

\item{dev}{Set to \code{TRUE} to install a course in development from the swirl_misc repository.}
}
\description{
We are currently maintaining a central repository of contributed
swirl courses at \url{https://github.com/swirldev/swirl_courses}.
This function provides the easiest method of installing a course
form the repository.

We have another repository at
\url{https://github.com/swirldev/swirl_misc}, where we keep
experimental features and content. The \code{dev} argument allows
you to access this repository. Content in the swirl_misc repository
is not guaranteed to work.
}
\examples{
\dontrun{

install_from_swirl("R_Programming") # Directory name

### OR ###

install_from_swirl("R Programming") # Course name

# To install a course in development from the swirl_misc repository
install_from_swirl("Including Data", dev = TRUE)
}
}
\seealso{
Other InstallCourses: \code{\link{InstallCourses}};
  \code{\link{install_course_directory}};
  \code{\link{install_course_dropbox}};
  \code{\link{install_course_github}};
  \code{\link{install_course_google_drive}};
  \code{\link{install_course_url}};
  \code{\link{install_course_zip}};
  \code{\link{uninstall_course}}; \code{\link{zip_course}}
}

