% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manifestFromLocal.R
\name{manifestFromCheckoutDir}
\alias{manifestFromCheckoutDir}
\title{Create Manifest from 'checkedout' directory containing many pkg dirs}
\usage{
manifestFromCheckoutDir(pdir, recursive = FALSE, excl_pat = NULL)
}
\arguments{
\item{pdir}{character(1). Parent directory which contains package source directories.}

\item{recursive}{logical(1). Should directories within \code{pdir} be searched recursively
to find package source directories. Defaults to \code{FALSE} for efficiency reasons.}

\item{excl_pat}{character(1) or NULL. A regular expression for directories/packages to
exclude from the manifest.}
}
\value{
A Package manifest with 'local' type entries for each package found within \code{pdir}.
}
\description{
This function is useful when a developer has a 'checkout' directory
where the sources for multiple packages live. Particularly, it
allows one to work on multiple interlocking packages at the same
time and have a manifest which will install them all together
automatically when time for testing.
}
\examples{
\dontrun{
manifestFromCheckoutDir(".")
}
}
