% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/manifestFromLib.R
\docType{methods}
\name{libManifest}
\alias{libManifest}
\alias{libManifest,SwitchrCtx}
\alias{libManifest,SwitchrCtx-method}
\alias{libManifest,character}
\alias{libManifest,character-method}
\alias{libManifest,missing}
\alias{libManifest,missing-method}
\title{libManifest
Create a Session- or PkgManifest for the contents of a switchr
library.}
\usage{
libManifest(lib = currentCompEnv(), record_versions = TRUE,
  known_manifest = makeManifest(dep_repos = repos), repos = defaultRepos(),
  ...)

\S4method{libManifest}{missing}(lib = currentCompEnv(),
  record_versions = TRUE, known_manifest = makeManifest(dep_repos = repos),
  repos = defaultRepos(), ...)

\S4method{libManifest}{character}(lib = currentCompEnv(),
  record_versions = TRUE, known_manifest = makeManifest(dep_repos = repos),
  repos = defaultRepos(), ...)

\S4method{libManifest}{SwitchrCtx}(lib = currentCompEnv(),
  record_versions = TRUE, known_manifest = makeManifest(dep_repos = repos),
  repos = defaultRepos(), ...)
}
\arguments{
\item{lib}{A SwitchrCtx object, or the name of a switchr library. Defaults
to the currently active switchr library.}

\item{record_versions}{Should the exact versions of installed packages be
recorded in the manifest (TRUE)}

\item{known_manifest}{An existing manifest, used when imputing
location information for packages not
installed via \code{\link{install_packages}}}

\item{repos}{A vector of traditional package repositories. Used when imputing
location information for packages not installed via
\code{\link{install_packages}}}

\item{\dots}{currently unused}
}
\description{
libManifest
Create a Session- or PkgManifest for the contents of a switchr
library.
}
\note{
The manifest generated by this function will not include
base packages, as they are part of R and not installable in the
traditional sense.
}
\examples{
man = libManifest()
man
\dontrun{
man2 = libManifest("myotherlib")
man2
}
}

