% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show.R
\name{showSymbolicQspray}
\alias{showSymbolicQspray}
\title{Print a 'symbolicQspray' object}
\usage{
showSymbolicQspray(
  showRatioOfQsprays,
  showMonomial,
  lbrace = "{ ",
  rbrace = " }",
  addition = "  +  ",
  multiplication = " * "
)
}
\arguments{
\item{showRatioOfQsprays}{a function which prints a \code{ratioOfQsprays}
object}

\item{showMonomial}{a function which prints a monomial, such as
\code{\link[qspray:showMonomialXYZ]{showMonomialXYZ()}} (and not
\code{showMonomialXYZ}!)}

\item{lbrace, rbrace}{used to enclose the coefficients}

\item{addition}{used to separate the terms}

\item{multiplication}{used to separate the coefficient and the monomial
within a term}
}
\value{
A function which prints a \code{symbolicQspray} object.
}
\description{
Prints a \code{symbolicQspray} object given a function to print
  a \code{ratioOfQsprays} object.
}
\note{
The function returned by this function is appropriate for usage in
  \code{\link{showSymbolicQsprayOption<-}} as the option
  \code{"showSymbolicQspray"} but in general we would rather
  use \code{\link{showSymbolicQsprayX1X2X3}} or
  \code{\link{showSymbolicQsprayXYZ}}, or rather set the options \code{"a"},
  \code{"X"} and \code{"quotientBar"}.
}
\examples{
set.seed(421)
( Qspray <- rSymbolicQspray() )
showRatioOfQsprays <-
  showRatioOfQspraysXYZ(c("a", "b", "c"), quotientBar = " / ")
showMonomial <- showMonomialX1X2X3("X")
f <- showSymbolicQspray(showRatioOfQsprays, showMonomial, "{{{", "}}}")
f(Qspray)
# setting a show option:
showSymbolicQsprayOption(Qspray, "showSymbolicQspray") <- f
Qspray
# the show options are preserved by certain operations, e.g.:
2*Qspray
}
\seealso{
\code{\link{showSymbolicQsprayX1X2X3}},
  \code{\link{showSymbolicQsprayXYZ}}.
}
