% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformation.R
\docType{methods}
\name{swapVariables}
\alias{swapVariables}
\alias{swapVariables,symbolicQspray,numeric,numeric-method}
\title{Swap variables}
\usage{
\S4method{swapVariables}{symbolicQspray,numeric,numeric}(x, i, j)
}
\arguments{
\item{x}{a \code{symbolicQspray} object}

\item{i, j}{indices of the variables to be swapped}
}
\value{
A \code{symbolicQspray} object.
}
\description{
Swap two variables of a \code{symbolicQspray}.
}
\examples{
library(symbolicQspray)
f <- function(a1, a2, X, Y, Z) {
  (a1^2 + 5*a2) / (a1 + 1) * X^2*Y  +  (3*a1 - a2) / a2 * Y^3
}
a1 <- qlone(1)
a2 <- qlone(2)
X <- Qlone(1)
Y <- Qlone(2)
Z <- Qlone(3)
Qspray <- f(a1, a2, X, Y, Z)
swapVariables(Qspray, 2, 3) == f(a1, a2, X, Z, Y) # should be TRUE
}
