/*
 * Decompiled with CFR 0.152.
 */
package dag;

import blbutil.FileIterator;
import dag.Dag;
import dag.DagLevel;
import dag.ImmutableDag;
import dag.MergeableDagLevel;
import dag.Score;
import haplotype.HapPairs;
import haplotype.HapsMarker;
import haplotype.HapsMarkerIterator;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import vcf.Marker;
import vcf.Markers;

public final class MergeableDag {
    private static final Score MAX_SCORE = new Score(-1, -1, Float.POSITIVE_INFINITY, false);
    private static final float MAX_THRESHOLD_RATIO = 1.4f;
    private final FileIterator<HapsMarker> it;
    private final float[] weights;
    private final int minWindow;
    private final int maxWindow;
    private final float scale;
    private final Dag dag;

    public static Dag dag(HapPairs hapPairs, float[] fArray, int n, float f) {
        try (HapsMarkerIterator hapsMarkerIterator = new HapsMarkerIterator(hapPairs);){
            MergeableDag mergeableDag = new MergeableDag(hapsMarkerIterator, hapPairs.markers(), fArray, n, f);
            Dag dag = mergeableDag.dag();
            return dag;
        }
    }

    public static Dag dag(FileIterator<HapsMarker> fileIterator, float[] fArray, int n, float f) {
        Markers markers = null;
        return new MergeableDag(fileIterator, markers, fArray, n, f).dag();
    }

    private MergeableDag(FileIterator<HapsMarker> fileIterator, Markers markers, float[] fArray, int n, float f) {
        DagLevel[] dagLevelArray;
        MergeableDag.checkParameters(fileIterator, fArray, n, f);
        this.it = fileIterator;
        this.weights = (float[])fArray.clone();
        this.minWindow = n / 12 + 1;
        this.maxWindow = n;
        this.scale = f;
        ArrayList<DagLevel> arrayList = new ArrayList<DagLevel>(25000);
        MergeableDagLevel mergeableDagLevel = new MergeableDagLevel((HapsMarker)fileIterator.next(), fArray);
        MergeableDag.readLevels(fileIterator, fArray, mergeableDagLevel, this.minWindow);
        while (mergeableDagLevel.next() != null) {
            mergeableDagLevel = mergeableDagLevel.next();
            this.mergeParentNodes(mergeableDagLevel);
            dagLevelArray = mergeableDagLevel.setPreviousToNull();
            arrayList.add(dagLevelArray.toDagLevel());
        }
        arrayList.add(mergeableDagLevel.toDagLevel());
        if (markers == null) {
            markers = MergeableDag.markers(arrayList);
        }
        dagLevelArray = arrayList.toArray(new DagLevel[0]);
        this.dag = new ImmutableDag(markers, dagLevelArray);
    }

    private static Markers markers(List<DagLevel> list) {
        Marker[] markerArray = new Marker[list.size()];
        for (int i = 0; i < markerArray.length; ++i) {
            markerArray[i] = list.get(i).marker();
        }
        return new Markers(markerArray);
    }

    public Dag dag() {
        return this.dag;
    }

    private static void checkParameters(FileIterator<HapsMarker> fileIterator, float[] fArray, int n, double d) {
        if (!fileIterator.hasNext()) {
            throw new IllegalArgumentException("it.hasNext()==false");
        }
        for (int i = 0; i < fArray.length; ++i) {
            float f = fArray[i];
            if (!((double)f <= 0.0) && !Float.isNaN(f) && !Float.isInfinite(f)) continue;
            throw new IllegalArgumentException("weights[" + i + "]=" + f);
        }
        if (n < 1) {
            throw new IllegalArgumentException("maxWindow: " + n);
        }
        if (Double.isInfinite(d) || Double.isNaN(d) || d <= 0.0) {
            throw new IllegalArgumentException("scale: " + d);
        }
    }

    private static void readLevels(FileIterator<HapsMarker> fileIterator, float[] fArray, MergeableDagLevel mergeableDagLevel, int n) {
        for (int i = 0; i < n && fileIterator.hasNext(); ++i) {
            MergeableDagLevel mergeableDagLevel2 = new MergeableDagLevel(mergeableDagLevel, (HapsMarker)fileIterator.next(), fArray);
            mergeableDagLevel.setNextLevel(mergeableDagLevel2);
            mergeableDagLevel = mergeableDagLevel2;
        }
    }

    private void mergeParentNodes(MergeableDagLevel mergeableDagLevel) {
        LinkedList<Score> linkedList = new LinkedList<Score>();
        Score score = this.getPairwiseScores(mergeableDagLevel, linkedList);
        while (score.isMergeable()) {
            int n = score.nodeA();
            int n2 = score.nodeB();
            if (!mergeableDagLevel.hasSibling(n)) {
                n = score.nodeB();
                n2 = score.nodeA();
                assert (mergeableDagLevel.hasSibling(n));
            } else if (mergeableDagLevel.hasSibling(n2) && mergeableDagLevel.nodeCount(score.nodeA()) < mergeableDagLevel.nodeCount(score.nodeB())) {
                n2 = score.nodeB();
                n = score.nodeA();
            }
            mergeableDagLevel.mergeParentNodes(n, n2);
            score = MAX_SCORE;
            ListIterator<Score> listIterator = linkedList.listIterator();
            while (listIterator.hasNext()) {
                Score score2 = (Score)listIterator.next();
                if (score2.nodeA() == n2 || score2.nodeB() == n2) {
                    listIterator.remove();
                    continue;
                }
                if (score2.nodeA() == n || score2.nodeB() == n) {
                    if ((score2 = this.score(mergeableDagLevel, score2.nodeA(), score2.nodeB())) != null) {
                        if (score2.score() < score.score() && score2.isMergeable()) {
                            score = score2;
                        }
                        listIterator.set(score2);
                        continue;
                    }
                    listIterator.remove();
                    continue;
                }
                if (!(score2.score() < score.score()) || !score2.isMergeable()) continue;
                score = score2;
            }
        }
    }

    private Score getPairwiseScores(MergeableDagLevel mergeableDagLevel, List<Score> list) {
        if (mergeableDagLevel.next() == null) {
            MergeableDag.readLevels(this.it, this.weights, mergeableDagLevel, this.minWindow);
        }
        Score score = MAX_SCORE;
        int[] nArray = mergeableDagLevel.parentNodeArray();
        boolean[] blArray = this.hasSibling(mergeableDagLevel, nArray);
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            for (int j = i + 1; j < nArray.length; ++j) {
                Score score2;
                int n2 = nArray[j];
                if (!blArray[i] && !blArray[j] || (score2 = this.score(mergeableDagLevel, n, n2)) == null) continue;
                if (score2.score() < score.score() && score2.isMergeable()) {
                    score = score2;
                }
                list.add(score2);
            }
        }
        return score;
    }

    private boolean[] hasSibling(MergeableDagLevel mergeableDagLevel, int[] nArray) {
        boolean[] blArray = new boolean[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            blArray[i] = mergeableDagLevel.hasSibling(nArray[i]);
        }
        return blArray;
    }

    private Score score(MergeableDagLevel mergeableDagLevel, int n, int n2) {
        float f = 0.0f;
        float f2 = mergeableDagLevel.nodeCount(n);
        float f3 = mergeableDagLevel.nodeCount(n2);
        float f4 = (float)((double)this.scale * Math.sqrt(1.0 / (double)f2 + 1.0 / (double)f3));
        f = this.similar(mergeableDagLevel.previous(), mergeableDagLevel, n, n2, f2, f3, mergeableDagLevel.markerIndex(), f2, f3, f, f4);
        if (f > 1.4f * f4) {
            return null;
        }
        boolean bl = f < f4;
        return new Score(n, n2, f, bl);
    }

    private MergeableDagLevel nextLevel(MergeableDagLevel mergeableDagLevel, int n, float f, float f2, float f3, float f4) {
        float f5 = 0.7f * f4;
        float f6 = 0.5f * f4;
        int n2 = mergeableDagLevel.markerIndex() - n;
        if (n2 < this.maxWindow && (f3 > f5 && Math.min(f, f2) > f6 || n2 < this.minWindow)) {
            MergeableDagLevel mergeableDagLevel2 = new MergeableDagLevel(mergeableDagLevel, (HapsMarker)this.it.next(), this.weights);
            mergeableDagLevel.setNextLevel(mergeableDagLevel2);
            return mergeableDagLevel2;
        }
        return null;
    }

    private float similar(MergeableDagLevel mergeableDagLevel, MergeableDagLevel mergeableDagLevel2, int n, int n2, float f, float f2, int n3, float f3, float f4, float f5, float f6) {
        float f7 = f / f3;
        float f8 = f2 / f4;
        float f9 = Math.abs(f7 - f8);
        if (f9 >= f6) {
            return f9;
        }
        if (f7 <= f5 && f8 <= f5) {
            return f5;
        }
        if (f9 > f5) {
            f5 = f9;
        }
        if (mergeableDagLevel2 == null && this.it.hasNext()) {
            mergeableDagLevel2 = this.nextLevel(mergeableDagLevel, n3, f7, f8, f5, f6);
        }
        if (n == -1 || n2 == -1 || mergeableDagLevel2 == null) {
            return f5;
        }
        int n4 = mergeableDagLevel2.nAlleles();
        for (int i = 0; i < n4; ++i) {
            int n5 = mergeableDagLevel2.outEdge(n, i);
            int n6 = mergeableDagLevel2.outEdge(n2, i);
            int n7 = n5 != -1 ? mergeableDagLevel2.childNode(n5) : -1;
            int n8 = n6 != -1 ? mergeableDagLevel2.childNode(n6) : -1;
            f = n5 != -1 ? mergeableDagLevel2.edgeCount(n5) : 0.0f;
            f2 = n6 != -1 ? mergeableDagLevel2.edgeCount(n6) : 0.0f;
            float f10 = this.similar(mergeableDagLevel2, mergeableDagLevel2.next(), n7, n8, f, f2, n3, f3, f4, f5, f6);
            if (!(f10 > f5)) continue;
            if (f10 >= f6) {
                return f10;
            }
            f5 = f10;
        }
        return f5;
    }

    public String toString() {
        return this.dag.toString();
    }
}

