\name{plot.LDmat}
\alias{plot.LDmat}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Plot function for class \code{LDmat}}
\description{
A function to visualize Linkage Disequilibrium estimates between adjacent markers or isualization of pairwise Linkage Disequilibrium (LD) estimates generated by function \code{pairwiseLD} in a LD heatmap for each chromosome using the \code{LDheatmap} package (Shin et al, 2006) .
}
\usage{
\method{plot}{LDmat}(x, gpData, plotType = "map", dense = FALSE, nMarker = TRUE, centr = NULL, chr = NULL, file = NULL, fileFormat = "pdf", onefile = TRUE, ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{
Object of class \code{LDmat}, i.e the output of function \code{pairwiseLD} with argument \code{type="matrix"}.
}
  \item{gpData}{
Object of class \code{gpData} with object \code{map}
}
  \item{plotType}{
You can decide, if you like to have a plot with the LD of the neighbouring markers (option \code{"neighbour"}), or you like to have a heatmap of the LD (default option \code{"map"}).
}
  \item{dense}{
For \code{plotType="neighbour"}, \code{logical}. Should density visualization for high-density genetic maps be used?
}
  \item{nMarker}{
For \code{plotType="neighbour"}, \code{logical}. Print number of markers for each chromosome?
}
  \item{centr}{
For \code{plotType="neighbour"}, \code{numeric} vector. Positions for the centromeres in the same order as chromosomes in \code{map}. If \code{"maize"}, centromere positions of maize in Mbp are used.
}
  \item{chr}{
For \code{plotType="map"}, \code{numeric} scalar or vector. Return value is a plot for each chromosome in \code{chr}. Note: Remember to add in a batch-script one empty line for each chromosome, if you use more than one chromosome!
}  
  \item{file}{
Optionally a path to a file where the plot is saved to
}
  \item{fileFormat}{
\code{character}. At the moment two file formats are supported: pdf and png. Default is \code{"pdf"}.
}
  \item{onefile}{
\code{logical}. If \code{fileFormat = "pdf"} you can decide, if you like to have all graphics in one file or in multiple files.
}
  \item{\dots}{
Further arguments that could be passed to function \code{LDheatmap}
}
}
\details{
For more details see at \code{\link{plotNeighbourLD}} or \code{\link{LDMap}}}
%%\value{
%%  ~Describe the value returned
%%  If it is a LIST, use
%%  \item{comp1 }{Description of 'comp1'}
%%  \item{comp2 }{Description of 'comp2'}
%% ...
%%}
%%\references{
%% ~put references to the literature/web site here ~
%%}
\author{
Hans-Juergen Auinger}
%%\note{
%%  ~~further notes~~
%%}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
\code{\link{plotNeighbourLD}}, \code{\link{LDDist}}, \code{\link{plotGenMap}}, \code{\link{pairwiseLD}}
}
%%\examples{
%%
%%}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ ~kwd1 }
\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
