% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/google.R
\name{font.add.google}
\alias{font.add.google}
\title{Load Google Fonts into 'sysfonts'}
\usage{
font.add.google(name, family = name, regular.wt = 400, bold.wt = 700,
  repo = "http://fonts.gstatic.com/")
}
\arguments{
\item{name}{name of the font that will be searched in Google Fonts}

\item{family}{family name of the font that will be used in R}

\item{regular.wt}{font weight for the regular font face, usually 400}

\item{bold.wt}{font weight for the bold font face, usually 700}

\item{repo}{the site that hosts the font files. Default is the official
repository \code{http://fonts.gstatic.com/} provided by
Google Fonts.}
}
\description{
This function will search the Google Fonts repository
(\url{https://fonts.google.com/}) for a specified
family name, download the proper font files, and then add them to \pkg{sysfonts}.
This function requires the \pkg{jsonlite} and \pkg{curl} packages.
}
\details{
There are hundreds of open source fonts in the Google Fonts
         repository (\url{https://fonts.google.com/}).
         This function will try to search the font family specified
         by the \code{name} argument, and then automatically
         download the font files for all possible font faces
         ("regular", "bold", "italic" and "bold italic",
         but no"symbol").
         If fonts are found and downloaded successfully, they will be
         also added to \pkg{sysfonts} with the given family name.
}
\examples{
\dontrun{
font.add.google("Alegreya Sans", "aleg")

if(require(showtext))
{
    wd = setwd(tempdir())
    pdf("google-fonts-ex.pdf")
    showtext.begin()
    
    par(family = "aleg")
    plot(0:5,0:5, type="n")
    text(1:4, 1:4, "Alegreya Sans", font=1:4, cex = 2)
    
    showtext.end()
    dev.off()
    setwd(wd)
}

}
}
\seealso{
\code{\link{font.families.google}()}
}
\author{
Yixuan Qiu <\url{http://statr.me/}>
}
