% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{GibbsSteps_kcycle}
\alias{GibbsSteps_kcycle}
\title{Gibbs sampling step of a matrix in the ERE model}
\usage{
GibbsSteps_kcycle(L, lambda, p, it = 1000L, eps = 1e-10, debug = 0L)
}
\arguments{
\item{L}{Starting matrix - will be modified to contain the results.}

\item{lambda}{Matrix of intensities}

\item{p}{Matrix of probabilities (must be in [0,1])}

\item{it}{Number of iterations (default=1000)}

\item{eps}{Threshold for values to be interpreted as equal to 0 (default = 1e-10)}

\item{debug}{Should addtional debug information be printed? (0 no output, 1 output debug information)}
}
\value{
no return value
}
\description{
The sampling is conditional on row and column sums and uses k-cycle steps. Then dimensions of L, lambda and p must match.
}
\examples{
L <- matrix(c(1,2,3,4,5,6,7,8,9),nrow=3)
diag(L) <- 0
lambda <- matrix(0.5,nrow=3,ncol=3)
p <- matrix(0.7, nrow=3,ncol=3)
diag(p) <- 0
GibbsSteps_kcycle(L=L,lambda=lambda,p=p)
L
L <- matrix(1:16,nrow=4)
diag(L) <- 0
lambda <- matrix(0.5,nrow=4,ncol=4)
p <- matrix(0.25, nrow=4,ncol=4)
diag(p) <- 0
GibbsSteps_kcycle(L=L,lambda=lambda,p=p)
L
}

