% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/trakt.user.followers.R
\name{trakt.user.followers}
\alias{trakt.user.followers}
\title{Get a user's followers}
\usage{
trakt.user.followers(user = getOption("trakt.username"))
}
\arguments{
\item{user}{Target user. Defaults to \code{getOption("trakt.username")}}
}
\value{
A \code{data.frame} containing user information.
}
\description{
\code{trakt.user.followers} pulls a user's followers
Since no OAuth2 methods are supported yet, the specified user mustn't be private.
}
\note{
See \href{http://docs.trakt.apiary.io/reference/users/followers/get-followers}{the trakt API docs for further info}
}
\examples{
\dontrun{
get_trakt_credentials() # Set required API data/headers
trakt.user.followers("jemus42")
}
}
\seealso{
Other user: \code{\link{trakt.user.collection}};
  \code{\link{trakt.user.following}};
  \code{\link{trakt.user.friends}};
  \code{\link{trakt.user.ratings}};
  \code{\link{trakt.user.stats}};
  \code{\link{trakt.user.watched}};
  \code{\link{trakt.user.watchlist}}
}

