% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiModelTP.R
\name{multiModelTP}
\alias{multiModelTP}
\title{Multiple model calculation of trophic position}
\usage{
multiModelTP(siData = siData, lambda = 2, n.chains = 2, n.adapt = 20000,
  n.iter = 20000, burnin = 20000, thin = 10, models = c("oneBaseline",
  "twoBaselines", "twoBaselinesFull"), print = FALSE, quiet = FALSE, ...)
}
\arguments{
\item{siData}{an isotopeData class object.}

\item{lambda}{numerical value, represents the trophic level of baseline(s).}

\item{n.chains}{number of parallel chains for the model. If convergence
diagnostics (such as Gelman-Rubin) are printed, n.chains needs to be >= 2.}

\item{n.adapt}{number of adaptive iterations, before the actual sampling.}

\item{n.iter}{number of iterations for Bayesian modelling (posterior
sampling).}

\item{burnin}{number of iterations discarded as burn in.}

\item{thin}{thinning. Number of samples discarded while performing posterior
sampling.}

\item{models}{string or list representing Bayesian models. At the moment they
can be "oneBaseline", "twoBaselines" and/or "twoBaselinesFull".}

\item{print}{logical value to indicate whether Gelman and Rubin's convergence
diagnostic and summary of samples are printed.}

\item{quiet}{logical value to indicate whether messages generated during
compilation will be suppressed, as well as the progress bar during
adaptation.}

\item{...}{additional arguments passed to this function.}
}
\value{
For each model calculated, returns a data frame of 4 elements with
  raw posterior samples, a list with posterior TP samples, a list with
  posterior muDeltaN (if one baseline model was chosen) or alpha (if a two
  baselines model was chosen) and a data frame with a summary of posterior
  samples named gg.
}
\description{
This function takes an isotopeData class object and calculates by default
three Bayesian models: one and two baselines without carbon fractionation and
two baselines with carbon fractionation.
}
\examples{
isotopeData <- generateTPData()
models <- multiModelTP(isotopeData, n.adapt = 500, n.iter = 500,
burnin = 500)
credibilityIntervals(models$gg, x = "model")
}
