#' Data frame of food webs in Inari and Kilpis Lakes (Finland)
#'
#' Dataset of stable isotope values from two relatively large and deep
#' oligotrophic Finnish lakes Inari and Kilpis.
#'
#' @format A data frame with 7 variables:
#' \describe{
#'   \item{Lake}{factor, with two levels, each representing one Lake}
#'   \item{Species.group}{factor, with 20 levels, each representing one species}
#'   \item{d13C}{numeric, representing delta 13 C isotope values}
#'   \item{d15N}{numeric, representing delta 15 N isotope values}
#'   \item{C}{numeric, amount of carbon}
#'   \item{N}{numeric, amount of nitrogen}
#'   \item{C.N}{numeric, C/N ratio}
#' }
#'
#' @usage data("Finnish_Lakes")
"Finnish_Lakes"
