% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tabmulti.R
\name{tabmulti}
\alias{tabmulti}
\title{Create Table Comparing Characteristics Across Levels of a Categorical
Variable}
\usage{
tabmulti(formula = NULL, data, xvarname = NULL, yvarnames = NULL,
  ymeasures = NULL, columns = c("xgroups", "p"),
  listwise.deletion = FALSE, sep.char = ", ", xlevels = NULL,
  yvarlabels = NULL, ylevels = NULL, indent.spaces = 3,
  quantiles = NULL, quantile.vals = FALSE, latex = TRUE,
  decimals = NULL, formatp.list = NULL, n.headings = FALSE,
  print.html = FALSE, html.filename = "table1.html",
  tabmeans.list = NULL, tabmedians.list = NULL, tabfreq.list = NULL)
}
\arguments{
\item{formula}{Formula, e.g. \code{Age + Sex + Race + BMI ~ Group}.}

\item{data}{Data frame containing variables named in \code{formula}.}

\item{xvarname}{Character string with name of column variable. Should be one
of \code{names(data)}.}

\item{yvarnames}{Character vector with names of row variables. Each element
should be one of \code{names(data)}.}

\item{ymeasures}{Character vector specifying whether each \code{y} variable
should be summarized by mean, median, or frequency. For example, if you want
to compare frequencies for the first variable, means for the second, and
medians for the third, you would set
\code{ymeasures = c("freq", "mean", "median")}. If unspecified, function
compares means for numeric variables and frequencies for factor and character
variables.}

\item{columns}{Character vector specifying what columns to include. Choices
for each element are \code{"n"} for total sample size, \code{"overall"} for
overall statistics, \code{"xgroups"} for \code{x} group statistics,
\code{"test"} for test statistic, and \code{"p"} for p-value.}

\item{listwise.deletion}{Logical value for whether observations with missing
values for any \code{y} variable should be excluded entirely (as opposed to
using all available data for each comparison).}

\item{sep.char}{Character string with separator to place between lower and
upper bound of confidence intervals. Typically \code{"-"} or \code{", "}.}

\item{xlevels}{Character vector with labels for the levels of \code{x}, used
in column headings.}

\item{yvarlabels}{Named list specifying labels for certain \code{y}
variables. For example, if you want variables named "race" and "age_yrs" to
print as "Race/ethnicity" and "Age (years)", use
\\code{yvarlabels = list(race = "Race/ethnicity", age_yrs = "Age (years)")}.}

\item{ylevels}{Character vector (if only 1 frequency comparison) or list of
character vectors with labels for the levels of each categorical \code{y}
variable.}

\item{indent.spaces}{Integer value specifying how many spaces to indent
factor levels.}

\item{quantiles}{Numeric value. If specified, function compares \code{y}
variables across quantiles of \code{x}. For example, if \code{x} contains BMI
values and \code{yvarnames} includes HDL and race, setting
\code{quantiles = 3} compares mean BMI and distribution of race across BMI
tertiles.}

\item{quantile.vals}{Logical value for whether labels for \code{x} quantiles
should show quantile number and corresponding range, e.g. Q1 [0.00, 0.25),
rather than just the quantile number.}

\item{latex}{Logical value for whether to format table so it is
ready for printing in LaTeX via \code{\link[xtable]{xtable}} or
\code{\link[knitr]{kable}}.}

\item{decimals}{Numeric vector specifying number of decimal places for
numbers other than p-values for each \code{y} variable. Can be a single value
to use for all \code{y} variables.}

\item{formatp.list}{List of arguments to pass to \code{\link[tab]{formatp}}.}

\item{n.headings}{Logical value for whether to display group sample sizes in
parentheses in column headings.}

\item{print.html}{Logical value for whether to write a .html file with the
table to the current working directory.}

\item{html.filename}{Character string specifying the name of the .html file
that gets written if \code{print.html = TRUE}.}

\item{tabmeans.list}{List of arguments to pass to \code{\link{tabmeans}}.}

\item{tabmedians.list}{List of arguments to pass to \code{\link{tabmedians}}.}

\item{tabfreq.list}{List of arguments to pass to \code{\link{tabfreq}}.}
}
\value{
Data frame which you can print in R (e.g. with \strong{xtable}'s
\code{\link[xtable]{xtable}} or \strong{knitr}'s \code{\link[knitr]{kable}})
or export to Word, Excel, or some other program. To export the table, set
\code{print.html = TRUE}. This will result in a .html file being written to
your current working directory, which you can open and copy/paste into your
document.
}
\description{
Creates a table comparing multiple characteristics (e.g. median age, mean
BMI, and race/ethnicity distribution) across levels of \code{x}.
}
\examples{
# Compare age, sex, race, and BMI in control vs. treatment group
tabmulti(Age + Sex + Race + BMI ~ Group, data = tabdata) \%>\%
  kable()

# Same as previous, but compare medians rather than means for BMI
tabmulti(Age + Sex + Race + BMI ~ Group, data = tabdata,
         ymeasures = c("mean", "freq", "freq", "median")) \%>\%
  kable()


}
