% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VERBS-summarize.R
\name{summarize-table.express}
\alias{summarize-table.express}
\alias{summarize.ExprBuilder}
\alias{summarise.ExprBuilder}
\alias{summarize.EagerExprBuilder}
\alias{summarise.EagerExprBuilder}
\alias{summarize.data.table}
\alias{summarise.data.table}
\title{Summarize columns}
\usage{
\method{summarize}{ExprBuilder}(
  .data,
  ...,
  .assume_optimized = NULL,
  .parse = getOption("table.express.parse", FALSE),
  .chain = getOption("table.express.chain", TRUE)
)

\method{summarise}{ExprBuilder}(
  .data,
  ...,
  .assume_optimized = NULL,
  .parse = getOption("table.express.parse", FALSE),
  .chain = getOption("table.express.chain", TRUE)
)

\method{summarize}{EagerExprBuilder}(.data, ..., .parent_env = rlang::caller_env())

\method{summarise}{EagerExprBuilder}(.data, ..., .parent_env = rlang::caller_env())

\method{summarize}{data.table}(.data, ...)

\method{summarise}{data.table}(.data, ...)
}
\arguments{
\item{.data}{An instance of \link{ExprBuilder}.}

\item{...}{Clauses for transmuting columns. For \code{j} inside the \code{data.table}'s frame.}

\item{.assume_optimized}{An optional character vector with function names that you know
\code{data.table} can optimize. This will be added to this set of known names:
min, max, mean, median, var, sd, sum, prod, first, last. Note that using those functions (and only those in
a given call to this function) will prevent the expressions from using variables created by
previous expressions.}

\item{.parse}{Logical. Whether to apply \code{\link[rlang:parse_expr]{rlang::parse_expr()}} to obtain the expressions.}

\item{.chain}{Logical. Should a new frame be automatically chained to the expression if the
clause being set already exists?}

\item{.parent_env}{See \code{\link[=end_expr]{end_expr()}}}
}
\description{
Compute summaries for columns, perhaps by group.
}
\details{
The built expression is similar to what \code{transmute} builds, but the function also checks that the
results have length 1.

To see more examples, check the
\href{https://asardaes.github.io/table.express/articles/table.express.html}{vignette}, or the
\link{table.express-package} entry.
}
