% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table1.R
\name{render.default}
\alias{render.default}
\title{Render values for table output.}
\usage{
render.default(x, name, missing = any(is.na(x)), transpose = F,
  render.empty = "NA", render.continuous = render.continuous.default,
  render.categorical = render.categorical.default,
  render.missing = render.missing.default, ...)
}
\arguments{
\item{x}{A vector or numeric, factor, character or logical values.}

\item{name}{Name of the variable to be rendered (ignored).}

\item{missing}{Should missing values be included?}

\item{transpose}{Logical indicating whether on not the table is transposed.}

\item{render.empty}{A \code{character} to return when \code{x} is empty.}

\item{render.continuous}{A function to render continuous (i.e.
\code{numeric}) values. Can also be a \code{character} string, in which case
it is passed to \code{\link{parse.abbrev.render.code}}.}

\item{render.categorical}{A function to render categorical (i.e.
\code{factor}, \code{character} or \code{logical}) values. Can also be a
\code{character} string, in which case it is passed to
\code{\link{parse.abbrev.render.code}}.}

\item{render.missing}{A function to render missing (i.e. \code{NA}) values.
Can also be a \code{character} string, in which case it is passed to
\code{\link{parse.abbrev.render.code}}.}

\item{...}{Further arguments, passed to \code{\link{stats.apply.rounding}}.}
}
\value{
A \code{character} vector. Each element is to be displayed in a
separate cell in the table. The \code{\link{names}} of the vector are the
labels to use in the table. However, the first names should be empty as it
will be replaced by the name of the variable. Empty strings are allowed and
result in empty table cells.
}
\description{
Called from \code{\link{table1}} by default to render values for
displaying in the table. This function forwards the call to separate
functions for rendering continuous, categorical and missing values.
The idea is that each of these functions can be overridden to customize
the table output.
}
\examples{
x <- exp(rnorm(100, 1, 1))
render.default(x)
render.default(x, TRUE)

y <- factor(sample(0:1, 99, replace=TRUE), labels=c("Female", "Male"))
y[1:10] <- NA
render.default(y)

}
\keyword{utilities}
