% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_footer_css.R
\name{add_css_footer}
\alias{add_css_footer}
\title{Add css to tableHTML's footer}
\usage{
add_css_footer(tableHTML, css)
}
\arguments{
\item{tableHTML}{A tableHTML object created by the tableHTML function.}

\item{css}{A list of two elements with the corresponding css. The first element of the list
should be an atomic vector with the style definitions (e.g. background-color). The second
element will be an atomic vector with the same length as the first element, which will 
contain the style definitions' values (e.g. red). Check the examples for more information.}
}
\value{
A tableHTML object.
}
\description{
\code{add_css_footer} will add css to a tableHTML's footer
}
\details{
\code{add_css_footer} will add css to a tableHTML's footer.
}
\examples{
tableHTML(mtcars, footer = 'This is a footer') \%>\% 
  add_css_footer(css = list(c('color', 'font-size'), c('blue', '50px'))) 

tableHTML(mtcars, footer = 'This is a footer') \%>\% 
  add_css_footer(css = list(c('color', 'font-size'), c('blue', '50px'))) \%>\%
  add_css_footer(css = list('background-color', 'green'))

}

