% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constraints.checkPattern.R
\name{constraints.checkPattern}
\alias{constraints.checkPattern}
\title{Pattern matching}
\usage{
constraints.checkPattern(constraint, value)
}
\arguments{
\item{constraint}{character vector where matches are sought}

\item{value}{character string to be matched}
}
\value{
TRUE if the pattern constraint is met
}
\description{
Search for pattern matches (value) within a character vector (constraint).
A regular expression is used to test field values. 
If the regular expression matches then the value is valid. 
The values of this field \code{MUST} conform to the standard 
\href{http://www.w3.org/TR/xmlschema-2/#regexs}{XML Schema regular expression syntax}.
}
\examples{

constraints.checkPattern(constraint = '^test$', value = 'test')

constraints.checkPattern(constraint = '^test$', value = 'TEST')
}
\seealso{
\href{https://frictionlessdata.io/specs/table-schema/#constraints}{Constraints specifications}
}
