% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constraints.checkMinLength.R
\name{constraints.checkMinLength}
\alias{constraints.checkMinLength}
\title{Check if minimum character length constraint is met}
\usage{
constraints.checkMinLength(constraint, value)
}
\arguments{
\item{constraint}{numeric constraint, minimum character length}

\item{value}{character to meet the constraint}
}
\value{
TRUE if character length is equal to or greater than the constraint
}
\description{
Specify the minimum length of a character
}
\examples{

constraints.checkMinLength(constraint = list(3), value = "hi")

constraints.checkMinLength(constraint = 2, value = "hello")
}
\seealso{
\href{https://frictionlessdata.io/specs/table-schema/#constraints}{Constraints specifications}
}
