% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xtable.R
\name{as_xtable.tablet}
\alias{as_xtable.tablet}
\title{Coerce Tablet to Xtable}
\usage{
\method{as_xtable}{tablet}(
  x,
  caption = NULL,
  label = NULL,
  align = NULL,
  digits = NULL,
  display = NULL,
  auto = FALSE,
  variable = " ",
  format_name = function(x, ...) paste0("\\\\!\\\\!\\\\textbf{", x, "}"),
  format_stat = function(x, ...) x,
  format_value = function(x, ...) x,
  ...
)
}
\arguments{
\item{x}{\code{\link{tablet}}}

\item{caption}{passed to \code{\link[xtable]{xtableList}}}

\item{label}{passed to \code{\link[xtable]{xtableList}}}

\item{align}{passed to \code{\link[xtable]{xtableList}}}

\item{digits}{passed to \code{\link[xtable]{xtableList}}}

\item{display}{passed to \code{\link[xtable]{xtableList}}}

\item{format_name}{function to format variable names (accepts at least x and dots)}

\item{format_stat}{function to format names of statistics and factor levels (accepts at least x and dots)}

\item{format_value}{function to format cell values (accepts at least x and dots)}

\item{...}{passed to \code{\link[xtable]{xtableList}}}
}
\value{
like \code{\link[xtable]{xtableList}}
}
\description{
Renders a tablet as xtable.  Calls \code{\link[xtable]{xtable}} and implements
default aesthetics.
}
\examples{
library(boot)
library(dplyr)
library(magrittr)
library(xtable)
melanoma \%>\%
  select(-time, -year) \%>\%
  mutate(sex = factor(sex), ulcer = factor(ulcer)) \%>\%
  group_by(status) \%>\%
  tablet \%>\%
  as_xtable
}
\keyword{internal}
