% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tablet.R
\name{devalued.observations}
\alias{devalued.observations}
\title{Aggregate Values for Observations
Aggregates values for observations.
Accepts a list of formulas with result name on left and
aggregating expression on the right.
Behavior is undefined if any expression does not aggregate! (I.e., length != 1).
Expressions are evaluated in an environment where values are available as 'x',
grouped count is available as 'n' and ungouped count is available as 'N'.}
\usage{
\method{devalued}{observations}(
  x,
  ...,
  fun = list(sum ~ sum(x, na.rm = TRUE), pct ~ signif(digits = 3, sum/n * 100), ave ~
    signif(digits = 3, mean(x, na.rm = TRUE)), std ~ signif(digits = 3, sd(x, na.rm =
    TRUE)), med ~ signif(digits = 3, median(x, na.rm = TRUE)), min ~ signif(digits = 3,
    min(x, na.rm = TRUE)), max ~ signif(digits = 3, max(x, na.rm = TRUE))),
  silent = TRUE
)
}
\arguments{
\item{x}{observations}

\item{...}{passed formulas with matching LHS will replace corresponding element of fun.}

\item{fun}{default aggregate functions expressed as formulas}

\item{silent}{whether to suppress warnings from evaluations of 'fun'}
}
\value{
class 'devalued', presumably one record per group:
\item{_tablet_N}{number of records}
\item{_tablet_n}{number of records in group}
\item{_tablet_name}{observation identifier}
\item{_tablet_level}{factor level (or special value 'numeric' for numerics)}
\item{(other)}{additional column for each statistic in 'fun'}
}
\description{
Aggregate Values for Observations
Aggregates values for observations.
Accepts a list of formulas with result name on left and
aggregating expression on the right.
Behavior is undefined if any expression does not aggregate! (I.e., length != 1).
Expressions are evaluated in an environment where values are available as 'x',
grouped count is available as 'n' and ungouped count is available as 'N'.
}
\keyword{internal}
