% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/keys.R
\name{keys}
\alias{keys}
\alias{is_natural}
\alias{is_sharp}
\alias{is_flat}
\alias{n_sharps}
\alias{n_flats}
\alias{is_major}
\alias{is_minor}
\title{Key signatures}
\usage{
keys(type = c("all", "sharp", "flat"))

is_natural(key)

is_sharp(key)

is_flat(key)

n_sharps(key)

n_flats(key)

is_major(key)

is_minor(key)
}
\arguments{
\item{type}{character, defaults to \code{"all"}.}

\item{key}{character, key signature.}
}
\value{
character vector.
}
\description{
Helper functions for key signature information.
}
\details{
The \code{keys} function returns a vector of valid key signature IDs. These IDs are how key signatures are specified throughout \code{tabr}, including in the other helper functions here via \code{key}.
Like the other functions here, \code{is_sharp} and \code{is_flat} are for \emph{key signatures}, not single pitches whose sharp or flat status is always self-evident from their notation.
Major and minor keys are also self-evident from their notation, but \code{is_major} and \code{is_minor} can still be useful when programming.
}
\examples{
keys()
is_natural(c("c", "am", "c#"))
x <- c("a", "e_")
is_sharp(x)
is_flat(x)
n_sharps(x)
n_flats(x)
}
