% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_curve.R
\name{get_curve}
\alias{get_curve}
\title{Get and prepare curve}
\usage{
get_curve(curve = NULL, verbose = FALSE)
}
\arguments{
\item{curve}{SpatRaster. Curve value, vector, grid or list of grids indicating the relative altitude of a biogeographic system per time period compared to the present. A typical example is a sea level curve indicating the relative sea level position above or below sea level compared to the present.}

\item{verbose}{Boolean. FALSE: No messages are printed. TRUE: Standard verbose mode. 2: Very verbose mode, displaying detailed information.}
}
\value{
A SpatRaster or vector with curve values in a suitable format for the reconstruct function.
}
\description{
load a curve of interest
}
\examples{
curve <- get_curve('lambeck')
curve <- get_curve('cutler')
curve <- get_curve('IPCC')
curve <- get_curve('funza')

curve <- get_curve()
curve <- get_curve(10)
curve <- get_curve(c(0,100,200,300,400,500))

# period definition curve 
cur <- c(0,100,200,300,400,500) # altitudes
names(cur) <- c(0,1,2,3,4,5) # periods 
curve <- get_curve(cur)

# add source attribute
cur <- c(0,100,200,300,400,500) # altitudes
names(cur) <- c(0,1,2,3,4,5) # periods 
attr(cur, 'source') <- 'new curve' # curve source 
curve <- get_curve(cur) 

# custom-curve from data frame
cur <- data.frame(period=0:10, 
                  altitude=seq(0,-20,-2), 
                  source='custom')
curve <- get_curve(cur)

}
\seealso{
\href{https://uva_ibed_piac.gitlab.io/tabs/articles/Ba-tabs-curve.html}{curve}
}
\author{
Johannes De Groeve
}
