% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/index_diversity.R,
%   R/statistics.R
\docType{methods}
\name{resample}
\alias{resample}
\alias{resample-method}
\alias{bootstrap,DiversityIndex-method}
\alias{jackknife,DiversityIndex-method}
\alias{resample,numeric-method}
\title{Resampling Methods}
\usage{
resample(object, ...)

\S4method{bootstrap}{DiversityIndex}(object, n = 1000, f = NULL)

\S4method{jackknife}{DiversityIndex}(object)

\S4method{resample}{numeric}(object, do, n, size = sum(object), ..., f = NULL)
}
\arguments{
\item{object}{A \code{\link{numeric}} vector of count data (absolute frequencies).}

\item{...}{Extra arguments passed to \code{do}.}

\item{n}{A non-negative \code{\link{integer}} specifying the number of bootstrap
replications.}

\item{f}{A \code{\link{function}} that takes a single numeric vector (the result of
\code{do}) as argument.}

\item{do}{A \code{\link{function}} that takes \code{object} as an argument
and returns a single numeric value.}

\item{size}{A non-negative \code{\link{integer}} specifying the sample size.}
}
\value{
If \code{f} is \code{NULL}, \code{resample()} returns the \code{n} values of \code{do}. Else,
returns the result of \code{f} applied to the \code{n} values of \code{do}.

If \code{f} is \code{NULL}, \code{bootstrap()} and \code{jackknife()} return a \code{\link{data.frame}}
with the following elements (else, returns the result of \code{f} applied to the
\code{n} values of \code{do}) :
\describe{
\item{original}{The observed value of \code{do} applied to \code{object}.}
\item{mean}{The bootstrap/jackknife estimate of mean of \code{do}.}
\item{bias}{The bootstrap/jackknife estimate of bias of \code{do}.}
\item{error}{The boostrap/jackknife estimate of standard error of \code{do}.}
}
}
\description{
\itemize{
\item \code{resample()} simulate observations from a multinomial distribution.
\item \code{bootstrap()} generate bootstrap estimations of a statistic.
\item \code{jackknife()} generate jackknife estimations of a statistic.
}
}
\examples{
## Sample observations from a multinomial distribution
x <- sample(1:100, 50, TRUE)
resample(x, do = median, n = 100)

## Estimate the 25th, 50th and 95th percentiles
quant <- function(x) { quantile(x, probs = c(0.25, 0.50, 0.75)) }
resample(x, n = 100, do = median, f = quant)
}
\seealso{
\code{\link[stats:Multinom]{stats::rmultinom()}}
}
\author{
N. Frerebeau
}
\concept{resampling methods}
