% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tabula-package.R
\docType{package}
\name{tabula-package}
\alias{tabula-package}
\alias{tabula}
\title{tabula: Analysis and Visualization of Archaeological Count Data}
\description{
\if{html}{\figure{logo.png}{options: style='float: right' alt='logo' width='120'}}

An easy way to examine archaeological count data. This package provides several tests and measures of diversity: heterogeneity and evenness (Brillouin, Shannon, Simpson, etc.), richness and rarefaction (Chao1, Chao2, ACE, ICE, etc.), turnover and similarity (Brainerd-Robinson, etc.). It allows to easily visualize count data and statistical thresholds: rank vs abundance plots, heatmaps, Ford (1962) and Bertin (1977) diagrams, etc.
}
\details{
\tabular{ll}{
\strong{Version} \tab 3.3.0 \cr
\strong{License} \tab GPL-3 \cr
\strong{CRAN DOI} \tab \doi{10.32614/CRAN.package.tabula} \cr
\strong{Zenodo DOI} \tab \doi{10.5281/zenodo.1489944} \cr
\strong{JOSS DOI} \tab \doi{10.21105/joss.01821} \cr
}

Archéosciences Bordeaux (UMR 6034)\cr
Maison de l'Archéologie\cr
Université Bordeaux Montaigne\cr
33607 Pessac cedex\cr
France
}
\section{Package options}{

\pkg{tabula} uses the following \code{\link[=options]{options()}} to configure behavior:
\itemize{
\item \code{tabula.progress}: a \code{\link{logical}} scalar. Should progress bars be
displayed? Defaults to \code{\link[=interactive]{interactive()}}.
\item \code{tabula.verbose}: a \code{\link{logical}} scalar. Should \R report extra information
on progress? Defaults to \code{\link[=interactive]{interactive()}}.
}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://codeberg.org/tesselle/tabula}
  \item \url{https://packages.tesselle.org/tabula/}
  \item Report bugs at \url{https://codeberg.org/tesselle/tabula/issues}
}

}
\author{
\strong{Maintainer}: Nicolas Frerebeau \email{nicolas.frerebeau@u-bordeaux-montaigne.fr} (\href{https://orcid.org/0000-0001-5759-4944}{ORCID})

Other contributors:
\itemize{
  \item Matthew Peeples \email{matthew.peeples@asu.edu} (\href{https://orcid.org/0000-0003-4496-623X}{ORCID}) [contributor]
  \item Ben Marwick \email{bmarwick@uw.edu} (\href{https://orcid.org/0000-0001-7879-4531}{ORCID}) [contributor]
  \item Jean-Baptiste Fourvel \email{jean-baptiste.fourvel@univ-amu.fr} (\href{https://orcid.org/0000-0002-1061-4642}{ORCID}) [contributor]
  \item Brice Lebrun (\href{https://orcid.org/0000-0001-7503-8685}{ORCID}) (Logo designer) [artist]
  \item Université Bordeaux Montaigne (\href{https://ror.org/03pbgwk21}{ROR}) [funder]
  \item CNRS (\href{https://ror.org/02feahw73}{ROR}) [funder]
}

}
\keyword{internal}
