% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmt_class.R
\name{fmt}
\alias{fmt}
\alias{is_fmt}
\alias{get_num}
\alias{set_num}
\alias{get_type}
\alias{set_type}
\alias{is_totrow}
\alias{as_totrow}
\alias{is_tottab}
\alias{as_tottab}
\alias{is_totcol}
\alias{as_totcol}
\title{Create a vector of class formatted numbers}
\usage{
fmt(
  n = integer(),
  type = "n",
  digits = rep(0L, length(n)),
  display = dplyr::case_when(type == "mean" ~ "mean", type \%in\% c("row", "col",
    "all", "all_tabs") ~ "pct", TRUE ~ "n"),
  wn = rep(NA_real_, length(n)),
  pct = rep(NA_real_, length(n)),
  mean = rep(NA_real_, length(n)),
  diff = rep(NA_real_, length(n)),
  ctr = rep(NA_real_, length(n)),
  var = rep(NA_real_, length(n)),
  ci = rep(NA_real_, length(n)),
  in_totrow = rep(FALSE, length(n)),
  in_tottab = rep(FALSE, length(n)),
  in_refrow = rep(FALSE, length(n)),
  comp_all = NA,
  diff_type = "",
  ci_type = "",
  col_var = "",
  totcol = FALSE,
  refcol = FALSE,
  color = ""
)

is_fmt(x)

get_num(x)

set_num(x, value)

get_type(x, ...)

set_type(x, type)

is_totrow(x, ...)

as_totrow(x, in_totrow = TRUE)

is_tottab(x, ...)

as_tottab(x, in_tottab = TRUE)

is_totcol(x, ...)

as_totcol(x, totcol = TRUE)
}
\arguments{
\item{n}{The underlying count, as an integer vector of length \code{n()}. It is used
to calculate confidence intervals for percentages.}

\item{type}{The type of the column, which defines the type of background calculation
to be made (as a single string, since it's not a field but an attribute) :
\itemize{
\item \code{"n"}: counts
\item \code{"mean"}: mean column (from numeric variables)
\item \code{"row"}: row percentages
\item \code{"col"}: column percentages
\item \code{"all"}: frequencies by subtable/group (i.e. by \code{tab_vars})
\item \code{"all_tabs"}: frequencies for the whole table
}}

\item{digits}{The number of digits, as an integer, or an integer vector the length
of \code{n}.}

\item{display}{The display type : the name of the field you want to show when printing
the vector. Among \code{"n"}, \code{"wn"}, \code{"pct"}, \code{"diff"}, \code{"ctr"},
\code{"mean"}, \code{"var"}, \code{"ci"},
\code{"pct_ci"} (percentages with visible confidence interval),
\code{"mean_ci"} (means with visible confidence interval). As a single string, or a
character vector the length of \code{n}.}

\item{wn}{The underlying weighted counts, as a double vector the length of
\code{n}. It is used in certain operations on \code{\link{fmt}}, like means.}

\item{pct}{The percentages, as a double vector the length of \code{n}.
Calculate with \code{\link{tab_pct}}.}

\item{mean}{The means, as a double vector the length of \code{n}.}

\item{diff}{The differences (from totals or first cells),
as a double vector the length of \code{n}. Used to set colors for means and
row or col percentages. Calculate with \code{\link{tab_pct}}.}

\item{ctr}{The contributions of cells to (sub)tables variances,
as a double vector the length of \code{n}. Used to print colors when
\code{color = "contrib"}. The mean contribution of each (sub)table is written on
total rows (then, colors don't print well without total rows).
Calculate with \code{\link{tab_chi2}}.}

\item{var}{The cells variances, as a double vector the length of \code{n}.
Used with \code{type = "mean"} to calculate confidence intervals.
Calculate with \code{tab_plain}.}

\item{ci}{The confidence intervals, as a double vector the length of \code{n}.
Used to print colors (\code{"diff_ci"}, \code{"after_ci"}).
Calculate with \code{tab_ci}.}

\item{in_totrow}{\code{TRUE} when the cell is part of a total row}

\item{in_tottab}{\code{TRUE} when the cell is part of a total table}

\item{in_refrow}{\code{TRUE} when the cell is part of a reference row
(cf. \code{diff_type})}

\item{comp_all}{\code{FALSE} when the comparison level is the subtable/group,
\code{TRUE} when it is the whole table}

\item{diff_type}{The type of difference of the vector (calculate
with \code{\link{tab_pct}}) :
\itemize{
\item \code{""} or \code{"no"}: no differences have been calculated
\item \code{"tot"}: the reference row (or column) is the total row (or column)
\item \code{"first"}: the reference row (or column) is the first row (or column)
}}

\item{ci_type}{The type of confidence intervals of the vector (calculate
with \code{\link{tab_ci}}) :
\itemize{
\item \code{""} or \code{"no"}: no ci have been calculated
\item \code{"cell"}: absolute confidence intervals of cells percentages.
\item \code{"diff"}: confidence intervals of the difference between a cell and the
relative total cell (or relative first cell when \code{diff_type = "first"}).
\item \code{"auto"}: \code{"diff"} for means and row/col percentages,
\code{"cell"} for frequencies ("all", "all_tabs").
}}

\item{col_var}{The name of the \code{col_var} used to calculate the vector}

\item{totcol}{\code{TRUE} when the vector is a total column}

\item{refcol}{\code{TRUE} when the vector is a reference column}

\item{color}{The type of color to print :
\itemize{
\item \code{"no"}: no colors are printed.
\item \code{"diff"}: color percentages and means based on cells differences from
totals (or from first cells when \code{diff = "first"}).
\item \code{"diff_ci"}: color pct and means based on cells differences from totals
or first cells, removing coloring when the confidence interval of this difference
is higher than the difference itself.
\item \code{"after_ci"}: idem, but cut off the confidence interval from the
difference first.
\item \code{"contrib"}: color cells based on their contribution to variance
(except mean columns, from numeric variables).
}}

\item{x}{The object to test, to get a field in, or to modify.}

\item{value}{The value you want to inject in some \code{fmt} vector's vctrs::field
or attribute using a given "set" function.}

\item{...}{Used in methods to add arguments in the future.}
}
\value{
A vector of class \code{tabxplor_fmt}.

A logical vector.

A double vector.

A modified fmt vector.

A character vector with the vectors type.

A modified fmt vector.

A logical vector with the fmt vectors totrow field.

A modified fmt vector with totrow field changed.

A logical vector with the fmt vectors tottab field.

A modified fmt vector with tottab field changed.

A logical vector with the fmt vectors totcol attribute.

A modified fmt vector with totcol attribute changed.
}
\description{
\code{fmt} vectors, of class \code{tabxplor_fmt}, powers \pkg{tabxplor}
and \code{\link{tab}} tibbles.
As a \code{\link[vctrs:new_rcrd]{record}}, they stores all data necessary to
calculate percentages, Chi2 metadata or confidence intervals, but also to format and
color the table to help the user read it. You can access this data with
\code{\link[vctrs:field]{vctrs::field}}, or change it with
\code{\link[vctrs:field]{vctrs:field<-}}. A \code{fmt} vector have 13 fields :
\code{n}, \code{digits}, \code{display}, \code{wn}, \code{pct}, \code{mean},
\code{diff}, \code{ctr}, \code{var}, \code{ci}, \code{in_totrow},  \code{in_tottab},
\code{in_refrow}. Other arguments are attributes, attached not to each value, but to
the whole vector, like \code{type}, \code{totcol} or \code{color}. You can get them
with \code{\link[base:attr]{attr}} and modify them with
\code{\link[base:attr]{attr<-}}. Special functions listed below are made to
facilitate programming with with \pkg{tabxplor} formatted numbers.
\code{taxplfmt} vectors can use all standard operations, like +, -, sum(), or c(),
using \pkg{vctrs}.
}
\section{Functions}{
\itemize{
\item \code{is_fmt}: a test function for class fmt.

\item \code{get_num}: get the currently displayed field

\item \code{set_num}: set the currently displayed field (not changing display type)

\item \code{get_type}: get types of fmt columns (at \code{fmt} level or \code{tab} level)

\item \code{set_type}: set the column type attribute of a \code{fmt} vector

\item \code{is_totrow}: test function to detect cells in total rows
(at \code{fmt} level or \code{tab} level)

\item \code{as_totrow}: set the "in_totrow" field (belong to total row)

\item \code{is_tottab}: test function to detect cells in total tables
(at \code{fmt} level or \code{tab} level)

\item \code{as_tottab}: set the "in_tottab" field (belong to total table)

\item \code{is_totcol}: test function for total columns
(at \code{fmt} level or \code{tab} level)

\item \code{as_totcol}: set the "totcol" attribute of a \code{fmt} vector
}}

\examples{
f <- fmt(n = c(7, 19, 2), type = "row", pct = c(0.25, 0.679, 0.07))
f

# To get the currently displayed field :
get_num(f)

# To modify the currently displayed field :
set_num(f, c(1, 0, 0))


# See all the underlying fields of a fmt vector :
vctrs::vec_data(f)

# To get the numbers of digits :
vctrs::field(f, "digits")

# To get the count :
vctrs::field(f, "n")

# To get the display :
vctrs::field(f, "display")

# To modify the percentages :
vctrs::`field<-`(f, "pct", c(1, 0, 0))


# See all the attributes of a fmt vector :
attributes(f)

# To modify the "type" attribute of a fmt vector :
set_type(f, "col")

# To modify the "color" attribute of a fmt vector :
`attr<-`(f, "color", "contrib")


library(dplyr)
tabs <- tab(starwars, sex, hair_color, gender, na = "drop", pct = "row",
            rare_to_other = TRUE, n_min = 5)

# To identify the total columns, and work with them :
is_totcol(tabs)
tabs \%>\% mutate(across(where(is_totcol), ~ "total column"))

# To identify the total rows, and work with them :
is_totrow(tabs)
tabs \%>\%
  mutate(across(
    where(is_fmt),
    ~ if_else(is_totrow(.), true = "into_total_row", false = "normal_cell")
  ))

# To identify the total tables, and work with them :
tottabs <- is_tottab(tabs)
tabs \%>\% tibble::add_column(tottabs) \%>\%
  mutate(total = if_else(tottabs, "part of a total table", "normal cell"))

# To access the displayed numbers, as numeric vectors :
tabs \%>\% mutate(across(where(is_fmt), get_num))

# To access the displayed numbers, as character vectors (without colors) :
tabs \%>\% mutate(across(where(is_fmt), format))

# To access the (non-displayed) differences of the cells percentages from totals :
tabs \%>\% mutate(across(where(is_fmt), ~ vctrs::field(., "diff")))
}
