% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tagr.r
\name{ls_bytag}
\alias{ls_bytag}
\title{List objects in an environment by tag}
\usage{
ls_bytag(..., only.tags = TRUE, envir = parent.frame())
}
\arguments{
\item{...}{The tags to filter by.}

\item{only.tags}{Logical value indimessageing whether to include only objects that have at least one tag.}

\item{envir}{The environment to search for tagged objects (defaults to the parent frame).}
}
\value{
No return value. A table with information about each tagged object, including its name, type, and tags is printed to the console.
}
\description{
This function lists all objects in a specified environment that have all of the specified tags.
The tags are stored as attributes of the objects. If the only.tags argument is set to TRUE, only
objects that have at least one tag are listed. If no objects with the specified tags are found,
a message is printed to the console. If the specified environment does not exist, an error is thrown.
}
\examples{
# create some objects and add tags
x <- c(1, 2, 3)
y <- matrix(1:9, nrow = 3)
z <- "hello world"
add_tags(x, "foo")
add_tags(y, "bar")
add_tags(z, "baz")

# list objects with specified tags
ls_bytag("foo", "bar")

}
