% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrich.R
\name{enrich}
\alias{enrich}
\title{Enrich Clustering Parameter}
\usage{
enrich(object, additional_data = NULL, by = NULL)
}
\arguments{
\item{object}{A \code{medic} object for enrichment.}

\item{additional_data}{A data frame with additional data that may be
(left-)joined onto the \code{parameters} in \code{object}.}

\item{by}{A character vector of variables to join by. This variables is
passed to the \code{by} term in a \code{\link[dplyr:mutate-joins]{dplyr::left_join()}} and inherits its
behavior:

If \code{NULL}, the default, the join will perform a natural join, using all
variables in common across the \code{parameters} and
\code{additional_data}.

To join by different variables on \code{parameters} and
\code{additional_data}, use a named vector. For example,
\code{by = c("k" = "cluster_size")} will match \code{parameters$k} to
\code{additional_data$cluster_size}.

To join by multiple variables, use a vector with length > 1. For example,
\code{by = c("k", "summation_method")} will match \code{parameters$k} to
\code{additional_data$k} and \code{parameters$summation_method} to \cr
\code{additional_data$summation_method}. Use a named vector to match different
variables in \code{parameters} and \code{additional_data}.

For example, \code{by = c("k" = "cluster_size", "summation_method" = "sm")}
will match \code{parameters$k} to \code{additional_data$cluster_size} and
\code{parameters$summation_method} to \code{additional_data$sm}.}
}
\value{
An object of class \emph{medic}.
}
\description{
Enrich the parameter information in a clustering with user-defined data.
}
\details{
The \code{enrich()} function is a joining function used for enriching the
clustering characteristics with user-defined data. This function is used in
all of the investigative functions with a \code{additional_data} statement such as
\code{\link[=frequencies]{frequencies()}} and \code{\link[=amounts]{amounts()}}.
}
\examples{
clust <- medic(
   complications,
   id = id,
   atc = atc,
   timing = first_trimester:third_trimester,
   k = 3:5
)

new_parameters <- data.frame(k = 3:5, size = c("small", "small", "large"))

enrich(clust, new_parameters)

}
