% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform-smd.R
\name{smd_compare}
\alias{smd_compare}
\title{Create a SMD for a categorical set of column versus a numerical row}
\usage{
smd_compare(
  table,
  row,
  column,
  cell_style,
  style,
  smdformat = NULL,
  pformat = NULL,
  weight = NULL,
  test = FALSE,
  ...
)
}
\arguments{
\item{table}{The table object to modify}

\item{row}{The row variable object to use (numerical)}

\item{column}{The column variable to use (categorical)}

\item{cell_style}{list; cell styling functions}

\item{style}{character; chosen styling to final table}

\item{smdformat}{numeric, character or function; A formatting directive to be applied to smd}

\item{pformat}{numeric, character or function; A formatting directive to be applied to p-values}

\item{weight}{numeric; Vector of weights to apply to data when computing SMD}

\item{test}{logical; include statistical test results}

\item{...}{absorbs additional arugments. Unused at present.}
}
\value{
The modified table object
}
\description{
Given a row and column object from the parser apply a Kruskal test and output
the results horizontally. 1 X (n + no. categories + test statistic)
}
