% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compile-clmm2.R, R/compile.R, R/compile-rms.R
\name{tangram.clmm2}
\alias{tangram.clmm2}
\alias{tangram.summary.clmm2}
\alias{tangram}
\alias{tangram.numeric}
\alias{tangram.anova.lme}
\alias{tangram.data.frame}
\alias{tangram.formula}
\alias{tangram.character}
\alias{tangram.table}
\alias{tangram.ftable}
\alias{tangram.matrix}
\alias{tangram.tbl_df}
\alias{tangram.lm}
\alias{tangram.summary.lm}
\alias{tangram.rms}
\title{Table creation methods}
\usage{
\method{tangram}{clmm2}(
  x,
  id = NULL,
  style = "hmisc",
  caption = NULL,
  footnote = NULL,
  digits = NULL,
  ...
)

\method{tangram}{summary.clmm2}(
  x,
  id = NULL,
  style = "hmisc",
  caption = NULL,
  footnote = NULL,
  digits = NULL,
  pformat = "\%1.3f",
  include_p = FALSE,
  ...
)

tangram(x, ...)

\method{tangram}{numeric}(
  x,
  cols,
  id = NULL,
  caption = NULL,
  style = "hmisc",
  footnote = NULL,
  fixed_thead = NULL,
  ...
)

\method{tangram}{anova.lme}(
  x,
  id = NULL,
  style = "hmisc",
  caption = NULL,
  footnote = NULL,
  digits = NULL,
  fixed_thead = NULL,
  ...
)

\method{tangram}{data.frame}(
  x,
  id = NULL,
  colheader = NA,
  caption = NULL,
  style = "hmisc",
  footnote = NULL,
  after = NA,
  quant = seq(0, 1, 0.25),
  msd = TRUE,
  as.character = NULL,
  fixed_thead = NULL,
  exclude = NULL,
  ...
)

\method{tangram}{formula}(
  x,
  data = NULL,
  id = NULL,
  transforms = NULL,
  caption = NULL,
  style = "hmisc",
  footnote = NULL,
  after = NA,
  digits = NA,
  fixed_thead = NULL,
  exclude = NULL,
  ...
)

\method{tangram}{character}(x, ...)

\method{tangram}{table}(
  x,
  id = NULL,
  percents = FALSE,
  digits = 1,
  test = FALSE,
  footnote = NULL,
  ...
)

\method{tangram}{ftable}(x, id = NULL, ...)

\method{tangram}{matrix}(x, digits = NULL, ...)

\method{tangram}{tbl_df}(x, ...)

\method{tangram}{lm}(x, ...)

\method{tangram}{summary.lm}(x, id = NULL, format = NULL, pformat = NULL, tformat = NULL, ...)

\method{tangram}{rms}(
  x,
  data = NULL,
  short.labels = NULL,
  footnote = NULL,
  rnd.digits = 2,
  rnd.stats = rnd.digits,
  ...
)
}
\arguments{
\item{x}{object; depends on S3 type, could be rows, formula, string of a formula, data.frame or numerical rows, an rms.model}

\item{id}{character; A unique charcter id used to identify this table over multiple runs. No spaces.}

\item{style}{character; Desired rendering style, currently supports "hmisc", "nejm", and "lancet". Defaults to "hmisc"}

\item{caption}{character; A string with the desired caption}

\item{footnote}{character; A vector of character strings as footnotes}

\item{digits}{numeric; default number of digits to use for display of numerics}

\item{...}{addition models or data supplied to table construction routines}

\item{pformat}{function or character; A function to format p values}

\item{include_p}{logical; Include p-value when printing statistic}

\item{cols}{numeric; An integer of the number of cols to create}

\item{fixed_thead}{logical; On conversion to HTML5 should headers be treated as fixed?}

\item{colheader}{character; Use as column headers in final table}

\item{after}{function or list of functions; one or more functions to further process an abstract table}

\item{quant}{numeric; A vector of quantiles to use for summaries}

\item{msd}{logical; Include mean and standard deviation in numeric summary}

\item{as.character}{logical; if true data.frames all variables are passed through as.character and no numerical summary is provided.}

\item{exclude}{vector or list; When x is a data.frame this exclusion criteria is applied to the data. If this is a list then each list pair is the (column name, criteria). It is preferred to use a list to be specific.}

\item{data}{data.frame; data to use for rendering tangram object}

\item{transforms}{list of lists of functions; that contain the transformation to apply for summarization}

\item{percents}{logical; Display percents when rendering a table object. Defaults to FALSE}

\item{test}{logical or function; Perform default test or a statistical function that will return a test result when passed a row and column}

\item{format}{numeric or character; Format to apply to statistic}

\item{tformat}{numeric or character; format to apply to t-value}

\item{short.labels}{numeric; Named vector of variable labels to replace in interaction rows. Must be in format c("variable name" = "shortened label").}

\item{rnd.digits}{numeric; Digits to round reference, comparison, result and CI values to. Defaults to 2.}

\item{rnd.stats}{numeric; Digits to round model LR, R2, etc to. Defaults to rnd.digits.}
}
\value{
A tangram object (a table).
}
\description{
The tangram method is the principal method to create tables. It uses
R3 method dispatch. If one specifies rows and columns, one gets an empty
table of the given size. A formula or character will invoke the parser
and process the specified data into a table like \code{Hmisc::summaryM}.
Given an \code{rms} object it will summarize that model in a table. A
\code{data.frame} is converted directly into a table as well for later
rendering. Can create tables from summary.rms(), anova.rms(), and other rms object info to create a
single pretty table of model results. The rms and Hmisc packages are required.
}
\details{
Note that additional arguments are passed to any subsequent transform. This means that a lot
of possible arguments are not documented here but in the transform applied.
Examine their documentations for additional possible arguments if needed.
}
\examples{
tangram(1, 1)
tangram(data.frame(x=1:3, y=c('a','b','c')), id="mytbl1")
tangram(drug ~ bili + albumin + protime + sex + age + spiders, pbc, id="mytbl2")
tangram("drug~bili+albumin+stage::Categorical+protime+sex+age+spiders", pbc,"mytbl3")
}
\seealso{
Possible transforms are (see \code{\link{hmisc}}) (*default*),
\code{\link{nejm}} and \code{\link{lancet}}.
}
