% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_tapnet.R
\name{make_tapnet}
\alias{make_tapnet}
\title{Constructs an object of type "tapnet"}
\usage{
make_tapnet(
  tree_low,
  tree_high,
  networks,
  abun_low = NULL,
  abun_high = NULL,
  traits_low = NULL,
  traits_high = NULL,
  npems_lat = NULL,
  use.all.pems = FALSE
)
}
\arguments{
\item{tree_low}{phylogenetic tree of lower trophic level; required;}

\item{tree_high}{phylogenetic tree of higher trophic level; required;}

\item{networks}{a single or list of interaction network (as matrix); required;}

\item{abun_low}{named abundance vector(s) for lower trophic level (single vector or list of vectors); optional;}

\item{abun_high}{named abundance vector(s) for higher trophic level; optional;}

\item{traits_low}{lower trophic level traits (species x traits matrix with row and column names); optional;}

\item{traits_high}{higher trophic level traits (species x traits matrix with row and column names; optional;}

\item{npems_lat}{number of phylogenetic eigenvectors to be used to construct latent traits. If NULL, all eigenvectors will be used.}

\item{use.all.pems}{option to force the function to use all phylogenetic eigenvectors, not only those useful for describing the specific network's species.}
}
\value{
A tapnet object, i.e. an thoroughly organised list with the inputs as entries. If multiple networks are provided, each has its own list entry, with PEMs, traits and abundances given for each network separately, in addition to the overall phylogenetic eigenvectors across all networks. See example for, well, for an example.
}
\description{
Collates networks, traits and phylogenies into a consistent data structure used for all other tapnet functions
}
\details{
Tapnet objects are the starting point for almost all other tapnet functions. They contain the information on the species and the (quantitative) interaction network data.
}
\examples{
data(Tinoco)
tapnet_web1 <- make_tapnet(tree_low = plant_tree, tree_high = humm_tree, networks = networks[1], 
               traits_low = plant_traits, traits_high = humm_traits, npems_lat = 4)
str(tapnet_web1) # show tapnet structure

}
\references{
Benadi et al. in prep
}
\author{
Gita Benadi <gita.benadi@biom.uni-freiburg.de>
}
