% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_knitr_deps.R
\name{tar_knitr_deps}
\alias{tar_knitr_deps}
\title{List literate programming dependencies.}
\usage{
tar_knitr_deps(path)
}
\arguments{
\item{path}{Character vector, path to one or more R Markdown or
\code{knitr} reports.}
}
\value{
Character vector of the names of targets
that are dependencies of the \code{knitr} report.
}
\description{
List the target dependencies of one or more
literate programming reports (R Markdown or \code{knitr}).
}
\examples{
lines <- c(
  "---",
  "title: report",
  "output_format: html_document",
  "---",
  "",
  "```{r}",
  "tar_load(data1)",
  "tar_read(data2)",
  "```"
)
report <- tempfile()
writeLines(lines, report)
tar_knitr_deps(report)
}
