% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_resources_clustermq.R
\name{tar_resources_clustermq}
\alias{tar_resources_clustermq}
\title{Target resources: \code{clustermq} high-performance computing}
\usage{
tar_resources_clustermq(template = list())
}
\arguments{
\item{template}{Named list, \code{template} argument to
\code{clustermq::workers()}.}
}
\value{
Object of class \code{"tar_resources_clustermq"}, to be supplied
to the \code{clustermq} argument of \code{tar_resources()}.
}
\description{
Create the \code{clustermq} argument of \code{tar_resources()}
to specify optional high-performance computing settings
for \code{tar_make_clustermq()}.
For details, see the documentation of the \code{clustermq} R package
and the corresponding argument names in this help file.
}
\section{Resources}{

Functions \code{\link[=tar_target]{tar_target()}} and \code{\link[=tar_option_set]{tar_option_set()}}
each takes an optional \code{resources} argument to supply
non-default settings of various optional backends for data storage
and high-performance computing. The \code{tar_resources()} function
is a helper to supply those settings in the correct manner.
Resources are all-or-nothing: if you specify any resources
with \code{\link[=tar_target]{tar_target()}}, all the resources from \code{tar_option_get("resources")}
are dropped for that target. In other words, if you write
\code{tar_option_set(resources = resources_1)} and then
\code{tar_target(x, my_command(), resources = resources_2)}, then everything
in \code{resources_1} is discarded for target \code{x}.
}

\examples{
# Somewhere in you target script file (usually _targets.R):
tar_target(
  name,
  command(),
  resources = tar_resources(
    clustermq = tar_resources_clustermq(template = list(n_cores = 2))
  )
)
}
\seealso{
Other resources: 
\code{\link{tar_resources_aws}()},
\code{\link{tar_resources_feather}()},
\code{\link{tar_resources_fst}()},
\code{\link{tar_resources_future}()},
\code{\link{tar_resources_gcp}()},
\code{\link{tar_resources_parquet}()},
\code{\link{tar_resources_qs}()},
\code{\link{tar_resources_url}()},
\code{\link{tar_resources}()}
}
\concept{resources}
