% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_load.R
\name{tar_load}
\alias{tar_load}
\title{Load the values of targets.}
\usage{
tar_load(
  names,
  branches = NULL,
  meta = tar_meta(targets_only = TRUE),
  envir = parent.frame()
)
}
\arguments{
\item{names}{Names of the targets to load. You can supply
symbols, a character vector, or \code{tidyselect} helpers like \code{\link[=starts_with]{starts_with()}}.}

\item{branches}{Integer of indices of the branches to load
for any targets that are patterns.}

\item{meta}{Data frame of metadata from \code{\link[=tar_meta]{tar_meta()}}.
\code{tar_read()} with the default arguments can be inefficient for large
pipelines because all the metadata is stored in a single file.
However, if you call \code{\link[=tar_meta]{tar_meta()}} beforehand and supply it to the \code{meta}
argument, then successive calls to \code{tar_read()} may run much faster.}

\item{envir}{Environment to put the loaded targets.}
}
\value{
Nothing.
}
\description{
Load the return values of targets into the current environment
(or the environment of your choosing). For a typical target, the return
value lives in a file in \verb{_targets/objects/}. For dynamic files
(i.e. \code{format = "file"}) the paths loaded in place of the values.
}
\examples{
if (identical(Sys.getenv("TAR_LONG_EXAMPLES"), "true")) {
tar_dir({ # tar_dir() runs code from a temporary directory.
tar_script({
  list(
    tar_target(y1, 1 + 1),
    tar_target(y2, 1 + 1),
    tar_target(z, y1 + y2)
  )
}, ask = FALSE)
tar_make()
tar_load(starts_with("y"))
})
}
}
\seealso{
Other data: 
\code{\link{tar_load_raw}()},
\code{\link{tar_meta}()},
\code{\link{tar_objects}()},
\code{\link{tar_pid}()},
\code{\link{tar_process}()},
\code{\link{tar_read_raw}()},
\code{\link{tar_read}()}
}
\concept{data}
