% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxmap--parsers.R
\name{lookup_tax_data}
\alias{lookup_tax_data}
\title{Convert one or more data sets to taxmap}
\usage{
lookup_tax_data(tax_data, type, column = 1, datasets = list(),
  mappings = c(), database = "ncbi", include_tax_data = TRUE,
  use_database_ids = TRUE)
}
\arguments{
\item{tax_data}{A table, list, or vector that contain sequence IDs, taxon
IDs, or taxon names.
\itemize{
\item tables: The \code{column} option must be used to specify which column
contains the sequence IDs, taxon IDs, or taxon names.
\item lists: There must be only one item per list entry unless the \code{column}
option is used to specify what item to use in each list entry.
\item vectors: simply a vector of sequence IDs, taxon IDs, or taxon names.
}}

\item{type}{(\code{"seq_id"}, \code{"taxon_id"}, \code{"taxon_name"}) What type of
information can be used to look up the classifications.}

\item{column}{(\code{character} or \code{integer}) The name or index of the column that
contains information used to lookup classifications. This only applies when
a table or list is supplied to \code{tax_data}.}

\item{datasets}{Additional lists/vectors/tables that should be included in
the resulting \code{taxmap} object. The \code{mappings} option is use to specify how
these data sets relate to the \code{tax_data} and, by inference, what taxa apply
to each item.}

\item{mappings}{(named \code{character}) This defines how the taxonomic
information in \code{tax_data} applies to data in \code{datasets}. This option
should have the same number of inputs as \code{datasets}, with values
corresponding to each dataset. The names of the character vector specify
what information in \code{tax_data} is shared with info in each \code{dataset}, which
is specified by the corresponding values of the character vector. If there
are no shared variables, you can add \code{NA} as a placeholder, but you could
just leave that data out since it is not benefiting from being in the
taxmap object. The names/values can be one of the following:
\itemize{
\item For tables, the names of columns can be used.
\item \code{"{{index}}"} : This means to use the index of rows/items
\item \code{"{{name}}"}  : This means to use row/item names.
\item \code{"{{value}}"} : This means to use the values in vectors or lists. Lists
will be converted to vectors using \code{\link[=unlist]{unlist()}}.
}}

\item{database}{(\code{character}) The name of a database to use to look up
classifications. Options include "ncbi", "itis", "eol", "col", "tropicos",
and "nbn".}

\item{include_tax_data}{(\code{TRUE}/\code{FALSE}) Whether or not to include \code{tax_data}
as a dataset, like those in \code{datasets}.}

\item{use_database_ids}{(\code{TRUE}/\code{FALSE}) Whether or not to use downloaded
database taxon ids instead of arbitrary, automatically-generated taxon ids.}
}
\description{
Looks up taxonomic data from NCBI sequence IDs, taxon IDs, or taxon names
that are present in a dataset. Also can incorporate additional associated
datasets.
}
\examples{
\dontrun{

  # Make example data with taxonomic classifications
  species_data <- data.frame(tax = c("Mammalia;Carnivora;Felidae",
                                     "Mammalia;Carnivora;Felidae",
                                     "Mammalia;Carnivora;Ursidae"),
                             species = c("Panthera leo",
                                         "Panthera tigris",
                                         "Ursus americanus"),
                             species_id = c("A", "B", "C"))

  # Make example data associated with the taxonomic data
  # Note how this does not contain classifications, but
  # does have a varaible in common with "species_data" ("id" = "species_id")
  abundance <- data.frame(id = c("A", "B", "C", "A", "B", "C"),
                          sample_id = c(1, 1, 1, 2, 2, 2),
                          counts = c(23, 4, 3, 34, 5, 13))

  # Make another related data set named by species id
  common_names <- c(A = "Lion", B = "Tiger", C = "Bear", "Oh my!")

  # Make another related data set with no names
  foods <- list(c("ungulates", "boar"),
                c("ungulates", "boar"),
                c("salmon", "fruit", "nuts"))

  # Make a taxmap object with these three datasets
  x = lookup_tax_data(species_data,
                      type = "taxon_name",
                      datasets = list(counts = abundance,
                                      my_names = common_names,
                                      foods = foods),
                      mappings = c("species_id" = "id",
                                   "species_id" = "{{name}}",
                                   "{{index}}" = "{{index}}"),
                      column = "species")

  # Note how all the datasets have taxon ids now
  x$data

  # This allows for complex mappings between variables that other functions use
  map_data(x, my_names, foods)
  map_data(x, counts, my_names)
}
}
\seealso{
Other parsers: \code{\link{extract_tax_data}},
  \code{\link{parse_tax_data}}
}
