% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxon.R
\name{taxon}
\alias{taxon}
\title{Taxon class}
\usage{
taxon(name, rank = NULL, id = NULL, authority = NULL)
}
\arguments{
\item{name}{a TaxonName object \code{\link[=taxon_name]{taxon_name()}} or character string. if character
passed in, we'll coerce to a TaxonName object internally, required}

\item{rank}{a TaxonRank object \code{\link[=taxon_rank]{taxon_rank()}} or character string. if character
passed in, we'll coerce to a TaxonRank object internally, required}

\item{id}{a TaxonId object \code{\link[=taxon_id]{taxon_id()}}, numeric/integer, or character string.
if numeric/integer/character passed in, we'll coerce to a TaxonId object
internally, required}

\item{authority}{(character) a character string, optional}
}
\value{
An \code{R6Class} object of class \code{Taxon}
}
\description{
A class used to define a taxon.
}
\examples{
(x <- taxon(
  name = taxon_name("Poa annua"),
  rank = taxon_rank("species"),
  id = taxon_id(93036)
))
x$name
x$rank
x$id
}
\seealso{
Other classes: \code{\link{hierarchies}},
  \code{\link{hierarchy}}, \code{\link{taxa}},
  \code{\link{taxmap}}, \code{\link{taxon_database}},
  \code{\link{taxon_id}}, \code{\link{taxon_name}},
  \code{\link{taxon_rank}}, \code{\link{taxonomy}}
}
