% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxonomy--docs.R
\name{supertaxa_apply}
\alias{supertaxa_apply}
\title{Apply function to supertaxa of each taxon}
\arguments{
\item{obj}{The \code{\link[=taxonomy]{taxonomy()}} or \code{\link[=taxmap]{taxmap()}} object containing taxon
information to be queried.}

\item{func}{(\code{function}) The function to apply.}

\item{subset}{Taxon IDs, TRUE/FALSE vector, or taxon indexes of taxa to use.
Default: All taxa in \code{obj} will be used. Any variable name that appears in
\code{\link[=all_names]{all_names()}} can be used as if it was a vector on its own.}

\item{recursive}{(\code{logical} or \code{numeric}) If \code{FALSE}, only return the
supertaxa one rank above the target taxa. If \code{TRUE}, return all the
supertaxa of every supertaxa, etc. Positive numbers indicate the number of
recursions (i.e. number of ranks above the target taxon to return). \code{1} is
equivalent to \code{FALSE}. Negative numbers are equivalent to \code{TRUE}.}

\item{simplify}{(\code{logical}) If \code{TRUE}, then combine all the results into a
single vector of unique values.}

\item{include_input}{(\code{logical}) If \code{TRUE}, the input taxa are included in
the output}

\item{value}{What data to give to the function. Any result of
\code{all_names(obj)} can be used, but it usually only makes sense to use data
that has an associated taxon id.}

\item{na}{(\code{logical}) If \code{TRUE}, return \code{NA} where information
is not available.}

\item{...}{Extra arguments are passed to the function.}
}
\description{
Apply a function to the supertaxa for each taxon. This is similar
to using \code{\link[=supertaxa]{supertaxa()}} with \code{\link[=lapply]{lapply()}} or \code{\link[=sapply]{sapply()}}.
\preformatted{
obj$supertaxa_apply(func, subset = NULL, recursive = TRUE,
  simplify = FALSE, include_input = FALSE, value = "taxon_indexes",
  na = FALSE, ...)
supertaxa_apply(obj, func, subset = NULL, recursive = TRUE,
  simplify = FALSE, include_input = FALSE, value = "taxon_indexes",
  na = FALSE, ....)}
}
\examples{
# Get number of supertaxa that each taxon is contained in
supertaxa_apply(ex_taxmap, length)

# Get classifications for each taxon
# Note; this can be done with `classifications()` easier
supertaxa_apply(ex_taxmap, paste, collapse = ";", include_input = TRUE,
                value = "taxon_names")

}
