% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/children.R
\name{children}
\alias{children}
\alias{children.colid}
\alias{children.default}
\alias{children.ids}
\alias{children.tsn}
\alias{children.uid}
\title{Retrieve immediate children taxa for a given taxon name or ID.}
\usage{
children(...)

\method{children}{default}(x, db = NULL, ...)

\method{children}{tsn}(x, db = NULL, ...)

\method{children}{colid}(x, db = NULL, ...)

\method{children}{ids}(x, db = NULL, ...)

\method{children}{uid}(x, db = NULL, ...)
}
\arguments{
\item{...}{Further args passed on to \code{\link{col_children}},
  \code{\link{gethierarchydownfromtsn}}, or \code{\link{ncbi_children}}.
  See those functions for what parameters can be passed on.}

\item{x}{character; taxons to query.}

\item{db}{character; database to query. One or more of \code{itis}, \code{col}, or \code{ncbi}.}
}
\value{
A named list of data.frames with the children names of every supplied taxa.
You get an NA if there was no match in the database.
}
\description{
This function is different from \code{\link{downstream}} in that it only collects immediate
taxonomic children, while \code{\link{downstream}} collects taxonomic names down to a specified
taxonomic rank, e.g., getting all species in a family.
}
\examples{
\dontrun{
# Plug in taxon names
children("Salmo", db = 'col')
children("Salmo", db = 'itis')
children("Salmo", db = 'ncbi')

# Plug in IDs
(id <- get_colid("Apis"))
children(id)

## Equivalently, plug in the call to get the id via e.g., get_colid into children
identical(children(id), children(get_colid("Apis")))

(id <- get_colid("Apis"))
children(id)
children(get_colid("Apis"))

# Many taxa
(sp <- names_list("genus", 3))
children(sp, db = 'col')
children(sp, db = 'itis')

# Two data sources
(ids <- get_ids("Apis", db = c('col','itis')))
children(ids)
## same result
children(get_ids("Apis", db = c('col','itis')))
}
}

