% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nbn_classification.R
\name{nbn_classification}
\alias{nbn_classification}
\title{Search UK National Biodiversity Network database for taxonomic classification}
\usage{
nbn_classification(id, ...)
}
\arguments{
\item{id}{(character) An NBN idientifier.}

\item{...}{Further args passed on to \code{\link[httr]{GET}}.}
}
\description{
Search UK National Biodiversity Network database for taxonomic classification
}
\examples{
\dontrun{
nbn_classification(id="NHMSYS0000502940")

# get id first, then pass to this fxn
id <- get_nbnid("blue tit", rec_only = TRUE, rank = "Species")
nbn_classification(id)

library('httr')
nbn_classification(id="NHMSYS0000502940", config=verbose())
}
}
\author{
Scott Chamberlain, \email{myrmecocystus@gmail.com}
}

