% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tax_rank.R
\name{tax_rank}
\alias{tax_rank}
\title{Get rank for a given taxonomic name.}
\usage{
tax_rank(query = NULL, db = "itis", pref = "ncbi", verbose = TRUE, ...)
}
\arguments{
\item{query}{character; Vector of taxonomic names to query.}

\item{db}{character; The database to search from: 'tis', 'ncbi' or 'both'.
If 'both' both NCBI and ITIS will be queried. Result will be the union of
both. Note that each taxonomic data source has their own identifiers, so
that if you provide the wrong \code{db} value for the identifier you could
get a result, but it will likely be wrong (not what you were expecting).}

\item{pref}{If db = 'both', sets the preference for the union. Either 'ncbi'
or 'itis'.}

\item{verbose}{logical; If TRUE the actual taxon queried is printed on the
console.}

\item{...}{Other arguments passed to \code{\link[taxize]{get_tsn}} or \code{\link[taxize]{get_uid}}.}
}
\value{
A data.frame with one column for every queried taxon.
}
\description{
Get rank for a given taxonomic name.
}
\note{
While \code{\link[taxize]{tax_name}} returns the name of a specified
rank,
\code{\link[taxize]{tax_rank}} returns the actual rank of the taxon.
}
\examples{
\dontrun{
tax_rank(query = "Helianthus annuus", db = "itis")
tax_rank(query = "Helianthus annuus", db = "ncbi")
tax_rank(query = "Helianthus", db = "itis")

# query both
tax_rank(query=c("Helianthus annuus", 'Puma'), db="both")

# An alternative way would be to use classification() and sapply over
# the list
x <- 'Baetis'
classi <- classification(get_uid(x))
sapply(classi, function(x) x[nrow(x), 'rank'])
}
}
\seealso{
\code{\link[taxize]{classification}}, \code{\link[taxize]{tax_name}}
}

