% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classification.R
\name{classification}
\alias{classification}
\alias{classification.default}
\alias{classification.tsn}
\alias{classification.uid}
\alias{classification.eolid}
\alias{classification.colid}
\alias{classification.tpsid}
\alias{classification.gbifid}
\alias{classification.nbnid}
\alias{classification.tolid}
\alias{classification.wormsid}
\alias{classification.natservid}
\alias{classification.boldid}
\alias{classification.wiki}
\alias{classification.pow}
\alias{classification.ids}
\alias{cbind.classification}
\alias{rbind.classification}
\alias{cbind.classification_ids}
\alias{rbind.classification_ids}
\title{Retrieve the taxonomic hierarchy for a given taxon ID.}
\usage{
classification(...)

\method{classification}{default}(x, db = NULL, callopts = list(),
  return_id = TRUE, rows = NA, ...)

\method{classification}{tsn}(id, return_id = TRUE, ...)

\method{classification}{uid}(id, callopts = list(), return_id = TRUE,
  ...)

\method{classification}{eolid}(id, callopts = list(), return_id = TRUE,
  ...)

\method{classification}{colid}(id, start = NULL, checklist = NULL,
  callopts = list(), return_id = TRUE, ...)

\method{classification}{tpsid}(id, callopts = list(), return_id = TRUE,
  ...)

\method{classification}{gbifid}(id, callopts = list(),
  return_id = TRUE, ...)

\method{classification}{nbnid}(id, callopts = list(), return_id = TRUE,
  ...)

\method{classification}{tolid}(id, callopts = list(), return_id = TRUE,
  ...)

\method{classification}{wormsid}(id, callopts = list(),
  return_id = TRUE, ...)

\method{classification}{natservid}(id, callopts = list(),
  return_id = TRUE, ...)

\method{classification}{boldid}(id, callopts = list(),
  return_id = TRUE, ...)

\method{classification}{wiki}(id, callopts = list(), return_id = TRUE,
  ...)

\method{classification}{pow}(id, callopts = list(), return_id = TRUE,
  ...)

\method{classification}{ids}(id, ...)

\method{cbind}{classification}(...)

\method{rbind}{classification}(...)

\method{cbind}{classification_ids}(...)

\method{rbind}{classification_ids}(...)
}
\arguments{
\item{...}{For \code{classification}: other arguments passed to
\code{\link{get_tsn}},
\code{\link{get_uid}}, \code{\link{get_eolid}},
\code{\link{get_colid}}, \code{\link{get_tpsid}},
\code{\link{get_gbifid}}, \code{\link{get_wormsid}},
\code{\link{get_natservid}}, \code{\link{get_wormsid}},
\code{\link{get_wiki}}, \code{\link{get_pow}}. For \code{rbind.classification}
and \code{cbind.classification}: one or more objects of class
\code{classification}}

\item{x}{Vector of taxa names (character) or IDs (character or numeric)
to query.}

\item{db}{character; database to query. either \code{ncbi}, \code{itis},
\code{eol}, \code{col}, \code{tropicos}, \code{gbif}, \code{nbn},
\code{worms}, \code{natserv}, \code{bold}, \code{wiki}, or \code{pow}. Note that each
taxonomic data source has, their own identifiers, so that if you provide
the wrong \code{db} value for the identifier you could get a result, but
it will likely be wrong (not what you were expecting). If using ncbi, eol,
and/or tropicos, we recommend getting an API key; see
\code{\link{taxize-authentication}}}

\item{callopts}{Curl options passed on to \code{\link[crul]{verb-GET}}}

\item{return_id}{(logical) If \code{TRUE} (default), return the taxon id
as well as the name and rank of taxa in the lineage returned.
Ignored for natserv as they don't return IDs in their taxonomic
classification data.}

\item{rows}{(numeric) Any number from 1 to infinity. If the default NA,
all rows are considered. Note that this parameter is ignored if you pass
in a taxonomic id instead of a name of class character.}

\item{id}{character; identifiers, returned by \code{\link{get_tsn}},
\code{\link{get_uid}}, \code{\link{get_eolid}},
\code{\link{get_colid}}, \code{\link{get_tpsid}},
\code{\link{get_gbifid}}, \code{\link{get_tolid}},
\code{\link{get_wormsid}}, \code{\link{get_natservid}},
\code{\link{get_wormsid}}, \code{\link{get_wiki}},
\code{\link{get_pow}}}

\item{start}{The first record to return. If omitted, the results are
returned from the first record (start=0). This is useful if the total
number of results is larger than the maximum number of results returned by
a single Web service query (currently the maximum number of results returned
by a single query is 500 for terse queries and 50 for full queries).}

\item{checklist}{character; The year of the checklist to query, if you want
a specific year's checklist instead of the lastest as default (numeric).}
}
\value{
A named list of data.frames with the taxonomic classification of
   every supplied taxa.
}
\description{
Retrieve the taxonomic hierarchy for a given taxon ID.
}
\details{
If IDs are supplied directly (not from the \code{get_*} functions)
you must specify the type of ID. There is a timeout of 1/3 seconds between
queries to NCBI.

BEWARE: Right now, NBN doesn't return the queried taxon in the
classification. But you can attach it yourself quite easily of course.
This behavior is different from the other data sources.
}
\section{Lots of results}{

It may happen sometimes that you get more results back from your query
than will show in the data.frame on screen. Our advice is to refine your
query in those cases. On a data source basis we can attempt to help
make it easier to refine queries, whether it be with the data provider
(unlikely to happen), or in the code in this package (more likely) -
let us know if you run into too many results problem and we'll see what
we can do.
}

\section{Authentication}{

See \code{\link{taxize-authentication}}
}

\examples{
\dontrun{
# Plug in taxon IDs
classification(9606, db = 'ncbi')
classification(c(9606, 55062), db = 'ncbi')
classification(129313, db = 'itis')
classification(6985636, db = 'eol')
classification(126436, db = 'worms')
classification('Helianthus annuus', db = 'pow')
classification('Helianthus', db = 'pow')
classification('Asteraceae', db = 'pow')
classification("ELEMENT_GLOBAL.2.134717", db = 'natserv')
classification(c(2704179, 2441176), db = 'gbif')
classification(25509881, db = 'tropicos')
classification("NBNSYS0000004786", db = 'nbn')
classification(as.nbnid("NBNSYS0000004786"), db = 'nbn')
classification(3930798, db = 'tol')

## works the same if IDs are in class character
classification(c("2704179", "2441176"), db = 'gbif')
classification("Agapostemon", db = "bold")

# wikispecies
classification("Malus domestica", db = "wiki")
classification("Pinus contorta", db = "wiki")
classification("Pinus contorta", db = "wiki", wiki_site = "commons")
classification("Pinus contorta", db = "wiki", wiki_site = "pedia")
classification("Pinus contorta", db = "wiki", wiki_site = "pedia",
  wiki = "fr")

classification(get_wiki("Malus domestica", "commons"))
classification(get_wiki("Malus domestica", "species"))
classification(c("Pinus contorta", "Malus domestica"), db = "wiki")

# Plug in taxon names
## in this case, we use get_*() fxns internally to first get taxon IDs
classification("Oncorhynchus mykiss", db = "eol")
classification(c("Chironomus riparius", "aaa vva"), db = 'ncbi')
classification(c("Chironomus riparius", "aaa vva"), db = 'ncbi',
  messages=FALSE)
classification(c("Chironomus riparius", "aaa vva"), db = 'itis')
classification(c("Chironomus riparius", "aaa vva"), db = 'itis',
  messages=FALSE)
classification(c("Chironomus riparius", "aaa vva"), db = 'eol')
classification(c("Chironomus riparius", "aaa vva"), db = 'col')
classification("Alopias vulpinus", db = 'nbn')
classification('Gadus morhua', db = 'worms')
classification('Aquila chrysaetos', db = 'natserv')
classification('Gadus morhua', db = 'natserv')
classification('Pomatomus saltatrix', db = 'natserv')
classification('Aquila chrysaetos', db = 'natserv')
classification(c("Chironomus riparius", "aaa vva"), db = 'col',
  messages=FALSE)
classification(c("Chironomus riparius", "asdfasdfsfdfsd"), db = 'gbif')
classification("Chironomus", db = 'tol')
classification("Poa annua", db = 'tropicos')

# Use methods for get_uid, get_tsn, get_eolid, get_colid, get_tpsid
classification(get_uid(c("Chironomus riparius", "Puma concolor")))

classification(get_uid(c("Chironomus riparius", "aaa vva")))
classification(get_tsn(c("Chironomus riparius", "aaa vva")))
classification(get_tsn(c("Chironomus riparius", "aaa vva"),
  messages = FALSE))
classification(get_eolid(c("Chironomus riparius", "aaa vva")))
classification(get_colid(c("Chironomus riparius", "aaa vva")))
classification(get_tpsid(c("Poa annua", "aaa vva")))
classification(get_gbifid(c("Poa annua", "Bison bison")))

# Pass many ids from class "ids"
(out <- get_ids(names="Puma concolor", db = c('ncbi','gbif')))
(cl <- classification(out))

# Bind width-wise from class classification_ids
cbind(cl)

# Bind length-wise
rbind(cl)

# Many names to get_ids
(out <- get_ids(names=c("Puma concolor","Accipiter striatus"),
  db = c('ncbi','itis','col')))
(cl <- classification(out))
rbind(cl)
## cbind with so many names results in some messy data
cbind(cl)
## so you can turn off return_id
cbind( classification(out, return_id=FALSE) )

# rbind and cbind on class classification (from a
# call to get_colid, get_tsn, etc. other than get_ids)
(cl_col <- classification(
  get_colid(c("Puma concolor","Accipiter striatus"))))
rbind(cl_col)
cbind(cl_col)

(cl_uid <- classification(get_uid(c("Puma concolor",
  "Accipiter striatus")), return_id=FALSE))
rbind(cl_uid)
cbind(cl_uid)
## cbind works a bit odd when there are lots of ranks without names
(cl_uid <- classification(get_uid(c("Puma concolor","Accipiter striatus")),
  return_id=TRUE))
cbind(cl_uid)

(cl_tsn <- classification(get_tsn(c("Puma concolor","Accipiter striatus"))))
rbind(cl_tsn)
cbind(cl_tsn)

(tsns <- get_tsn(c("Puma concolor","Accipiter striatus")))
(cl_tsns <- classification(tsns))
cbind(cl_tsns)

# NBN data
(res <- classification(c("Alopias vulpinus","Pinus sylvestris"),
  db = 'nbn'))
rbind(res)
cbind(res)

# Return taxonomic IDs
## the return_id parameter is logical, and you can turn it on or off.
## It's TRUE by default
classification(c("Alopias vulpinus","Pinus sylvestris"), db = 'ncbi',
  return_id = TRUE)
classification(c("Alopias vulpinus","Pinus sylvestris"), db = 'ncbi',
  return_id = FALSE)

# Use rows parameter to select certain
classification('Poa annua', db = 'tropicos')
classification('Poa annua', db = 'tropicos', rows=1:4)
classification('Poa annua', db = 'tropicos', rows=1)
classification('Poa annua', db = 'tropicos', rows=6)
}

\dontrun{
# Fails without db param set
# classification(315576)
}
}
\seealso{
\code{\link{get_tsn}}, \code{\link{get_uid}},
   \code{\link{get_eolid}}, \code{\link{get_colid}},
   \code{\link{get_tpsid}}, \code{\link{get_gbifid}}
   \code{\link{get_wormsid}}, \code{\link{get_natservid}},
   \code{\link{get_boldid}}, \code{\link{get_wiki}},
   \code{\link{get_pow}}
}
