% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coerce-methods.R, R/df2taxlist.R
\name{as}
\alias{as}
\alias{S4_to_list}
\alias{coerce,taxlist,list-method}
\alias{coerce,taxlist,data.frame-method}
\alias{coerce,data.frame,taxlist-method}
\alias{coerce,character,taxlist-method}
\title{Coerce taxlist objects to lists.}
\usage{
S4_to_list(x)
}
\arguments{
\item{x}{An object of class \linkS4class{taxlist} or any S4 class.}
}
\value{
An object of class \link{list}.
}
\description{
Coercion of S4 objects to lists can be applied to explore their content,
avoiding errors caused by their validation.
}
\details{
Coerce \linkS4class{taxlist} objects to lists.
}
\examples{
## Coerce taxlist to list
tax_list <- as(Easplist, "list")

## Coerce data frame to taxlist
Cyperus <- read.csv(file = file.path(path.package("taxlist"), "cyperus",
        "names.csv"))
Cyperus$AcceptedName <- !Cyperus$SYNONYM
head(Cyperus)

as(Cyperus, "taxlist")
}
\author{
Miguel Alvarez \email{kamapu78@gmail.com}
}
