% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accepted_name.R
\name{accepted_name}
\alias{accepted_name}
\alias{accepted_name.taxlist}
\alias{accepted_name,taxlist-method}
\alias{accepted_name<-}
\alias{accepted_name<-.taxlist}
\alias{accepted_name<-,taxlist-method}
\alias{synonyms}
\alias{synonyms.taxlist}
\alias{synonyms,taxlist-method}
\alias{basionym}
\alias{basionym.taxlist}
\alias{basionym,taxlist-method}
\alias{basionym<-}
\alias{basionym<-.taxlist}
\alias{basionym<-,taxlist-method}
\alias{change_concept<-}
\alias{change_concept<-.taxlist}
\alias{change_concept<-,taxlist-method}
\title{Manage accepted names, synonyms and basionyms}
\usage{
accepted_name(taxlist, ...)

\method{accepted_name}{taxlist}(taxlist, ConceptID, show_traits = FALSE, ...)

accepted_name(taxlist, ...) <- value

\method{accepted_name}{taxlist}(taxlist, ConceptID, ...) <- value

synonyms(taxlist, ...)

\method{synonyms}{taxlist}(taxlist, ConceptID, ...)

basionym(taxlist, ...)

\method{basionym}{taxlist}(taxlist, ConceptID, ...)

basionym(taxlist, ...) <- value

\method{basionym}{taxlist}(taxlist, ConceptID, ...) <- value

change_concept(taxlist, ...) <- value

\method{change_concept}{taxlist}(taxlist, UsageID, ...) <- value
}
\arguments{
\item{taxlist}{An object of class \linkS4class{taxlist}.}

\item{...}{Further arguments passed among methods.}

\item{ConceptID}{Integer containing concept IDs where to request or set names
for one category.}

\item{show_traits}{Logical value, whether traits should be included in the
output of \code{accepted_name} or not.}

\item{value}{Integer containing usage IDs to be set to the respective
category in the respective taxon concept.}

\item{UsageID}{Numeric vector with taxon usage IDs that will be changed to a
different taxonomic concept.}
}
\value{
Most of the methods return information in data frames, while
replacement methods do it as \linkS4class{taxlist} objects.
}
\description{
Taxon usage names for a taxon concept can be divided into three categories:
accepted names, basionyms and synonyms.
Each single taxon concept may at least have an accepted name, while basionym
and synonyms are optional.

The function \code{accepted_name()} retrieves the accepted names for the indicated
taxon concepts or for the whole \linkS4class{taxlist} object.
By using \code{show_traits=TRUE}, the respective taxon traits will be
displayed as well, providing an overview of taxa included in the object.
The replacement method for this function will set the respective usage name
IDs as accepted names for the respective taxon concept, provided that these
names are already set as synonyms in the respective concepts.

The function \code{synonyms()} is working in a similar way as \code{accepted_name()},
but this function does not include taxon traits in the output.
Alternatives for inserting new synonyms into a taxon concept are either
moving synonyms from other taxa by using \link{change_concept<-} or
inserting new names in the object by using \code{\link[=add_synonym]{add_synonym()}}.

The function \code{basionym()} is retrieving and setting basionyms in the
respective taxon concepts similarly to \code{accepted_name}, but this function
does not retrieve any information on taxon traits, either.

The fucntion \verb{change_concept<-} replace a taxon usage name (argument
\code{'UsageID'}) to a different taxonomic concept (argument \code{'value'}).
}
\examples{
## Set a different accepted name for Cyclosorus interruptus
summary(Easplist, "Cyclosorus interruptus")
accepted_name(Easplist, 50074) <- 53097
summary(Easplist, 50074)

## Inserting a new name first
summary(Easplist, "Basella alba")
Easplist <- add_synonym(taxlist = Easplist, ConceptID = 68,
    TaxonName = "Basella cordifolia", AuthorName = "Lam.")
summary(Easplist, 68)
accepted_name(Easplist, 68) <- 56139
summary(Easplist, 68)

## Display synonyms
head(synonyms(taxlist = Easplist))

## Synonyms for an specific concept
synonyms(taxlist = Easplist, ConceptID = 20)

## Basionym for Cyclosrus interruptus
summary(Easplist, 50074)
basionym(Easplist, 50074) <- 53097

summary(Easplist, 50074)
basionym(Easplist, 50074)

## Move the name Typha aethiopica to concept 573 (T. latifolia)
summary(Easplist, c(50105, 573))
change_concept(Easplist, 53130) <- 573
summary(Easplist, c(50105, 573))
}
\seealso{
\code{\link[=add_synonym]{add_synonym()}} \link{change_concept<-}
}
\author{
Miguel Alvarez \email{kamapu78@gmail.com}
}
