% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_methods.R
\name{download_ncbi}
\alias{download_ncbi}
\title{Download the NCBI taxonomy}
\usage{
download_ncbi(taxonkitpath = NA)
}
\arguments{
\item{taxonkitpath}{A string containing the full path to where \code{Taxonkit} is installed (optional).}
}
\value{
A character vector containing paths to the relevant downloaded and unzipped NCBI data dump files, or
if the \code{taxonkitpath} parameter was set, the path to \code{All.lineages.tsv}.
}
\description{
Download the NCBI taxonomy
}
\details{
This method downloads a NCBI taxonomy archive file to a temporary directory,
extracts four files (\code{nodes.dmp}, \code{names.dmp}, \code{merged.dmp} and \code{delnodes.dmp})
from the downloaded archive file, and then removes the archive file. Further parsing of
these four files must be carried out with Taxonkit (\url{https://bioinf.shenwei.me/taxonkit/download/}),
either automatically or manually. If the path to a Taxonkit installation is supplied, Taxonkit is
called and the location of the four files is passed to Taxonkit as an argument for automatic parsing.
Taxonkit output is saved in the same temporary folder in a file called \code{All.lineages.tsv}.
If the path to Taxonkit is not supplied, parsing should be carried out manually using the command:
\verb{taxonkit list --ids 1 | taxonkit lineage --show-lineage-taxids --show-lineage-ranks --show-rank --show-name --data-dir=path/to/downloaded/files | taxonkit reformat > All.lineages.tsv}
}
\examples{
\dontrun{download_ncbi()}
\dontrun{download_ncbi(taxonkitpath = "/home/usr/bin/taxonkit")}
}
