% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_synonyms.R
\name{get_synonyms}
\alias{get_synonyms}
\title{get synonyms}
\usage{
get_synonyms(master = NULL, checklist = NULL, commasep = FALSE, verbose = TRUE)
}
\arguments{
\item{master}{master list of names (taxolist)}

\item{checklist}{list of names to be processed (taxolist)}

\item{commasep}{return list should be comma separated list or each synonym on
its own row. Default false}

\item{verbose}{verbose output on the console}
}
\value{
Data frame with names from the checklist and their synonyms present
in the master list
}
\description{
get all the synonyms from the master list for the names
in the checklist
}
\examples{
\donttest{
master <- data.frame("id" = c(1,2,3),
                     "canonical" = c("Hypochlorosis ancharia",
                                     "Hypochlorosis tenebrosa",
                                     "Hypochlorosis ancharia tenebrosa"),
                     "family" = c("Lycaenidae", "Lycaenidae", "Lycaenidae"),
                     "accid" = c(0,1,0),
                     "source" = c("itis","itis","itis"),
                     stringsAsFactors = FALSE)

checklist <- data.frame("id" = c(1,2,3,4,5),
                        "canonical" = c("Hypochlorosis ancharia",
                                        "Pseudonotis humboldti",
                                        "Myrina ancharia",
                                        "Hypochlorosis ancharia obiana",
                                        "Hypochlorosis lorquinii"),
                        "family" = c("Lycaenidae", "Lycaenidae", 
                                     "Lycaenidae", "Lycaenidae",
                                      "Lycaenidae"),
                        "accid" = c(0,1,1,0,0),
                        "source" = c("itis","wiki","wiki","itis",
                                     "itis"),
                        stringsAsFactors = FALSE)
get_synonyms(master,checklist,commasep=FALSE)
get_synonyms(master,checklist,commasep=TRUE)
}
}
\seealso{
Other List functions: 
\code{\link{DwC2taxo}()},
\code{\link{cast_cs_field}()},
\code{\link{compact_ids}()},
\code{\link{match_lists}()},
\code{\link{melt_cs_field}()},
\code{\link{merge_lists}()},
\code{\link{syn2taxo}()},
\code{\link{synonymize_subspecies}()},
\code{\link{taxo2DwC}()},
\code{\link{taxo2doc}()},
\code{\link{taxo2syn}()},
\code{\link{wiki2taxo}()}
}
\concept{List functions}
