% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/syn2taxo.R
\name{syn2taxo}
\alias{syn2taxo}
\title{Synonym list to taxolist}
\usage{
syn2taxo(synlist, canonical = "canonical", synonym = "synonym")
}
\arguments{
\item{synlist}{Synonym list with Accepted name and Synonym columns}

\item{canonical}{Accepted names column name, Default: 'canonical'}

\item{synonym}{Synonym column name , Default: 'synonym'}
}
\value{
returns a taxolist format list will all the names in same column and
accepted names linked to synonyms with id and accid fields
}
\description{
Converts a Synonym list with Accepted Names and Synonym columns
to taxolist format
}
\details{
Converts a synonyms list to taxolist format
}
\examples{
\dontrun{
if(interactive()){
 taxolist <- syn2taxo(synlist)
 }
}
}
\seealso{
Other List functions: 
\code{\link{cast_cs_field}()},
\code{\link{melt_cs_field}()},
\code{\link{merge_lists}()},
\code{\link{wiki2taxo}()}
}
\concept{List functions}
