% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/join.R
\name{full_join_data}
\alias{full_join_data}
\alias{left_join_data}
\alias{right_join_data}
\title{Joins}
\usage{
full_join_data(x, y, by = NULL)

left_join_data(x, y, by = NULL)

right_join_data(x, y, by = NULL)
}
\arguments{
\item{x}{Left or first data frame}

\item{y}{Right or second data frame}

\item{by}{Name (character) of variable(s) on which to join}
}
\value{
Joined (merged) data frame
}
\description{
Full join: join two data frames preserving all possible information

Left join: Join two data frames by matching the second (right) data frame to
the left (first) such that the structure of the first (left) data frame is
preserved

Right join: Join two data frames by matching the first (left) data frame to
the right (second) such that the structure of the second (right) data frame
is preserved
}
\examples{

d1 <- tbl_data(
  x = 1:10,
  y = rnorm(10),
  z = letters[1:10]
)
d2 <- tbl_data(
  x = sample(1:10, 20, replace = TRUE),
  y2 = rnorm(20)
)

## left join
left_join_data(d1, d2)

## right join
right_join_data(d1, d2)

## full join
full_join_data(d1, d2)

}
