% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/repoverlap.R
\name{repOverlap}
\alias{repOverlap}
\title{General function for the repertoire overlap evaluation.}
\usage{
repOverlap(.data, .method = c("exact", "hamm", "lev", "jaccard", "morisita",
  "tversky", "overlap", "horn"), .seq = c("nuc", "aa"),
  .quant = c("read.count", "umi.count", "read.prop", "umi.prop"),
  .vgene = F, .norm = T, .a = 0.5, .b = 0.5, .do.unique = T,
  .verbose = T)
}
\arguments{
\item{.data}{List of clonesets.}

\item{.method}{Which method to use for the overlap evaluation. See "Details" for methods.}

\item{.seq}{Which clonotype sequences to use for the overlap: "nuc" for "CDR3.nucleotide.sequence", "aa" for
"CDR3.amino.acid.sequence".}

\item{.quant}{Which column to use for the quantity of clonotypes: "read.count" for the "Read.count" column,
"umi.count" for the "Umi.count" column, "read.prop" for the "Read.proportion" column, "umi.prop" for
the "Umi.proportion" column. Used in "morisita" and "horn".}

\item{.vgene}{If T than use V genes in computing shared or similar clonotypes. Used in all methods.}

\item{.norm}{If T than compute the normalised number of shared clonotypes. Used in "exact".}

\item{.a,.b}{Alpha and beta parameters for "tversky". Default values gives the Jaccard index measure.}

\item{.do.unique}{If T than remove duplicates from the input data, but add their quantities to their clones.}

\item{.verbose}{If T than output the data processing progress bar.}
}
\description{
General interface to all cloneset overlap functions.
}
\details{
You can see a more detailed description for each overlap method at \link{intersectClonesets} and \link{similarity}.

Parameter \code{.method} can have one of the following value each corresponding to the specific method:

- "exact" for the shared number of clonotypes (basic function \code{intersectClonesets(..., .type = "..e")}).

- "hamm" for the number of similar clonotypes by the Hamming distance (basic function \code{intersectClonesets(..., .type = "..h")}).

- "lev" for the number of similar clonotypes by the Levenshtein distance (basic function \code{intersectClonesets(..., .type = "..l")}).

- "jaccard" for the Jaccard index (basic function \code{jaccard.index}).

- "morisita" for the Morisita's overlap index (basic function \code{morisita.index}).

- "tversky" for the Tversky index (basic function \code{tversky.index}).

- "overlap" for the overlap coefficient (basic function \code{overlap.coef}).

- "horn" for the Horn's index (basic function \code{horn.index}).
}
\examples{
\dontrun{
data(twb)
repOverlap(twb, "exact", .seq = "nuc", .vgene = F)
repOverlap(twb, "morisita", .seq = "aa", .vgene = T, .quant = "umi.count")
}
}
\seealso{
\link{intersectClonesets}, \link{similarity}, \link{repDiversity}
}

