% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataproc.R
\name{tailbound.proportion}
\alias{clonal.proportion}
\alias{tailbound.proportion}
\alias{top.proportion}
\title{Proportions of specifyed subsets of clones.}
\usage{
tailbound.proportion(.data, .bound = 2, .col = 'Read.count')

top.proportion(.data, .head = 10, .col = 'Read.count')

clonal.proportion(.data, .perc = 10, .col = 'Read.count')
}
\arguments{
\item{.data}{Data frame or a list with data frames.}

\item{.bound}{Subset the \code{.data} by \code{.col} <= \code{.bound}.}

\item{.col}{Column's name with counts of sequences.}

\item{.head}{How many top values to choose - parameter to the \code{.head} function.}

\item{.perc}{Percentage (0 - 100).}
}
\value{
For \code{tailbound.proportion} - numeric vector of percentage.

For \code{top.proportion} - numeric vector of percentage for top clones.
For \code{clonal.proportion} - vector or matrix with values for number of clones, occupied percentage and proportion of the
chosen clones to the overall count of clones.
}
\description{
Get a specifyed subset of the given data and compute which proportion in counts
it has comparing to the overall count.

\code{tailbound.proportion} - subset by the count;

\code{top.proportion} - subset by rank (top N clones);

\code{clonal.proportion} - subset by a summary percentage (top N clones which in sum has the given percentage).
}
\examples{
\dontrun{
                                # How many clones fill up approximately
clonal.proportion(immdata, 25)  # the 25\% of the sum of values in 'Read.count'?

                                # What proportion of the top-10 clones' reads
vis.top.proportions(immdata)  # Plot this proportions.

                                # What proportion of sequences which
                                # has 'Read.count' <= 100 to the
tailbound.proportion(immdata, 100)  # overall number of reads?
}
}
\seealso{
\link{vis.top.proportions}
}

